/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.pipeline.AbstractValve;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class DetermineRedirectRequestedValve
extends AbstractValve {
    private static final Log log = LogFactory.getLog(DetermineRedirectRequestedValve.class);

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        this.redirectRequested(pipelineData);
        context.invokeNext(pipelineData);
    }

    protected void redirectRequested(PipelineData pipelineData) throws IOException {
        RunData data = this.getRunData(pipelineData);
        boolean requestRedirected = StringUtils.isNotEmpty((String)data.getRedirectURI());
        if (requestRedirected) {
            if (data.getResponse().isCommitted()) {
                log.warn((Object)("redirect requested, response already committed: " + data.getRedirectURI()));
            } else {
                data.getResponse().sendRedirect(data.getRedirectURI());
            }
        }
    }
}

