/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.rtf;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.rtf.ColorTbl;
import org.apache.ecs.rtf.Comment;
import org.apache.ecs.rtf.Info;
import org.apache.ecs.rtf.RTF;
import org.apache.ecs.rtf.RTFElement;
import org.apache.ecs.rtf.Subject;
import org.apache.ecs.rtf.Title;
import org.apache.ecs.rtf.Version;

public class RTFDocument {
    public static String ANSI = "\\ansi";
    public static String MAC = "\\mac";
    public static String PC = "\\pc";
    public static String PCA = "\\pca";
    private Info info = new Info();
    private Title title = new Title();
    private Subject subject = new Subject();
    private Comment comment = new Comment();
    private Version version = new Version();
    RTF rtf = new RTF();

    public RTFDocument() {
        this.rtf.addElement("charSet", ANSI);
        this.info.addElement(this.title);
        this.info.addElement(this.subject);
        this.info.addElement(this.version);
        this.info.addElement(this.comment);
        this.rtf.addElement(this.info);
    }

    public RTFDocument addElement(String string) {
        this.rtf.addElement(string);
        return this;
    }

    public RTFDocument addElement(String string, String string2) {
        this.rtf.addElement(string, string2);
        return this;
    }

    public RTFDocument addElement(String string, RTFElement rTFElement) {
        this.rtf.addElement(string, rTFElement);
        return this;
    }

    public RTFDocument addElement(RTFElement rTFElement) {
        this.rtf.addElement(rTFElement);
        return this;
    }

    public ConcreteElement getElement(String string) {
        return this.rtf.getElement(string);
    }

    public Info getInfo() {
        return this.info;
    }

    public void output(OutputStream outputStream) {
        this.rtf.output(outputStream);
    }

    public void output(PrintWriter printWriter) {
        this.rtf.output(printWriter);
    }

    public RTFDocument setCharacterSet(String string) {
        this.rtf.addElement("charSet", string);
        return this;
    }

    public RTFDocument setCodeSet(String string) {
        this.rtf.addElement("\\ansicpg" + string);
        return this;
    }

    public RTFDocument setColorTable(ColorTbl colorTbl) {
        this.rtf.addElement(colorTbl);
        return this;
    }

    public RTFDocument setComment(String string) {
        this.comment.addElement("comment", string);
        return this;
    }

    public RTFDocument setSubject(String string) {
        this.subject.addElement(string);
        return this;
    }

    public RTFDocument setTitle(String string) {
        this.title.addElement(string);
        return this;
    }

    public RTFDocument setVersion(int n) {
        this.version.setVersion(n);
        return this;
    }
}

