/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;

public enum UserAgentType {
    BROWSER("Browser"),
    EMAIL_CLIENT("Email client"),
    FEED_READER("Feed Reader"),
    LIBRARY("Library"),
    MEDIAPLAYER("Multimedia Player"),
    MOBILE_BROWSER("Mobile Browser"),
    OFFLINE_BROWSER("Offline Browser"),
    OTHER("Other"),
    ROBOT("Robot"),
    UNKNOWN(""),
    USERAGENT_ANONYMIZER("Useragent Anonymizer"),
    VALIDATOR("Validator"),
    WAP_BROWSER("Wap Browser");

    @Nonnull
    private final String name;

    public static UserAgentType evaluateByTypeName(@Nonnull String typeName) {
        Check.notNull((Object)typeName, (String)"typeName");
        UserAgentType result = UNKNOWN;
        for (UserAgentType value : UserAgentType.values()) {
            if (!value.getName().equals(typeName)) continue;
            result = value;
            break;
        }
        return result;
    }

    private UserAgentType(String name) {
        this.name = name;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }
}

