/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.parser.BaseValueParser;
import org.apache.fulcrum.parser.ValueParser;

public abstract class DataStreamParser
implements Iterator<ValueParser>,
LogEnabled {
    private List<String> columnNames;
    private final StreamTokenizer tokenizer;
    private ValueParser lineValues;
    private boolean neverRead = true;
    private String characterEncoding;
    protected Logger log;

    public DataStreamParser(Reader in, List<String> columnNames, String characterEncoding) {
        this.columnNames = columnNames;
        this.characterEncoding = characterEncoding;
        if (this.characterEncoding == null) {
            this.characterEncoding = "US-ASCII";
            try {
                this.characterEncoding = ((InputStreamReader)in).getEncoding();
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        this.tokenizer = new StreamTokenizer(new BufferedReader(in));
        this.initTokenizer(this.tokenizer);
    }

    protected abstract void initTokenizer(StreamTokenizer var1);

    public void enableLogging(Logger logger) {
        this.log = logger.getChildLogger("DataStreamParser");
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public void readColumnNames() throws IOException {
        this.columnNames = new ArrayList<String>();
        this.neverRead = false;
        this.tokenizer.nextToken();
        while (this.tokenizer.ttype == -3 || this.tokenizer.ttype == 34) {
            this.columnNames.add(this.tokenizer.sval);
            this.tokenizer.nextToken();
        }
    }

    public boolean hasNextRow() throws IOException {
        if (this.neverRead || this.tokenizer.ttype == 10) {
            this.tokenizer.nextToken();
            this.tokenizer.pushBack();
            this.neverRead = false;
        }
        return this.tokenizer.ttype != -1;
    }

    public ValueParser nextRow() throws IOException, NoSuchElementException {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException();
        }
        if (this.lineValues == null) {
            this.lineValues = new BaseValueParser(this.characterEncoding);
        } else {
            this.lineValues.clear();
        }
        Iterator<String> it = this.columnNames.iterator();
        this.tokenizer.nextToken();
        while (this.tokenizer.ttype == -3 || this.tokenizer.ttype == 34) {
            if (it.hasNext()) {
                String colname = it.next().toString();
                String colval = this.tokenizer.sval;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("DataStreamParser.nextRow(): " + colname + '=' + colval);
                }
                this.lineValues.add(colname, colval);
            }
            this.tokenizer.nextToken();
        }
        return this.lineValues;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = false;
        try {
            hasNext = this.hasNextRow();
        }
        catch (IOException e) {
            this.log.error("IOException in CSVParser.hasNext", (Throwable)e);
        }
        return hasNext;
    }

    @Override
    public ValueParser next() throws NoSuchElementException {
        ValueParser nextRow = null;
        try {
            nextRow = this.nextRow();
        }
        catch (IOException e) {
            this.log.error("IOException in CSVParser.next", (Throwable)e);
            throw new NoSuchElementException();
        }
        return nextRow;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

