/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.rundata;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.naming.Context;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ecs.Document;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.fulcrum.mimetype.MimeTypeService;
import org.apache.fulcrum.parser.CookieParser;
import org.apache.fulcrum.parser.ParameterParser;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.turbine.Turbine;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.DefaultPipelineData;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.rundata.TurbineRunData;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.FormMessages;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.SystemError;
import org.apache.turbine.util.template.TemplateInfo;

public class DefaultTurbineRunData
extends DefaultPipelineData
implements TurbineRunData,
Recyclable {
    private boolean disposed;
    private static Locale defaultLocale = null;
    private static String defaultCharSet = null;
    private boolean pageSet;
    private Document page;
    private String action;
    private String layout;
    private String screen;
    private String templateEncoding;
    private String title;
    private boolean outSet;
    private PrintWriter out;
    private String charSet;
    private String contentType = "text/html";
    private String redirectURI;
    private int statusCode = 200;
    private final List<SystemError> errors = new ArrayList<SystemError>();
    private Map<String, Context> jndiContexts;
    private String remoteAddr;
    private String remoteHost;
    private String userAgent;
    private String stackTrace;
    private Throwable stackTraceException;
    private final Map<String, Object> debugVariables = new HashMap<String, Object>();
    private static Log log = LogFactory.getLog(DefaultTurbineRunData.class);

    public static <T extends User> T getUserFromSession(HttpSession session) {
        try {
            User user = (User)session.getAttribute("turbine.user");
            return (T)user;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static boolean removeUserFromSession(HttpSession session) {
        try {
            session.removeAttribute("turbine.user");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected static Locale getDefaultLocale() {
        if (defaultLocale == null) {
            String lang = Turbine.getConfiguration().getString("locale.default.language", "en");
            String country = Turbine.getConfiguration().getString("locale.default.country", "US");
            defaultLocale = new Locale(lang, country);
        }
        return defaultLocale;
    }

    protected String getDefaultCharSet() {
        String charset;
        log.debug((Object)"getDefaultCharSet()");
        if (defaultCharSet == null) {
            defaultCharSet = Turbine.getConfiguration().getString("locale.default.charset", "ISO-8859-1");
            log.debug((Object)("defaultCharSet = " + defaultCharSet + " (From Properties)"));
        }
        if (StringUtils.isEmpty((String)(charset = defaultCharSet))) {
            log.debug((Object)"charset is empty!");
            Locale locale = this.getLocale();
            if (locale == null) {
                locale = DefaultTurbineRunData.getDefaultLocale();
                log.debug((Object)("Locale was null, is now " + locale + " (from getDefaultLocale())"));
            }
            log.debug((Object)("Locale is " + locale));
            if (!locale.equals(Locale.US)) {
                log.debug((Object)"We don't have US Locale!");
                ServiceManager serviceManager = TurbineServices.getInstance();
                MimeTypeService mimeTypeService = null;
                try {
                    mimeTypeService = (MimeTypeService)serviceManager.getService(MimeTypeService.ROLE);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                charset = mimeTypeService.getCharSet(locale);
                log.debug((Object)("Charset now " + charset));
            }
        }
        log.debug((Object)("Returning default Charset of " + charset));
        return charset;
    }

    public DefaultTurbineRunData() {
        this.put(Turbine.class, new HashMap());
        this.recycle();
    }

    public void recycle() {
        this.disposed = false;
    }

    public void dispose() {
        this.get(Turbine.class).clear();
        this.pageSet = false;
        this.page = null;
        this.action = null;
        this.layout = null;
        this.screen = null;
        this.templateEncoding = null;
        this.title = null;
        this.outSet = false;
        this.out = null;
        this.charSet = null;
        this.contentType = "text/html";
        this.redirectURI = null;
        this.statusCode = 200;
        this.errors.clear();
        this.jndiContexts = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.userAgent = null;
        this.stackTrace = null;
        this.stackTraceException = null;
        this.debugVariables.clear();
    }

    @Override
    public ParameterParser getParameters() {
        ParameterParser parameters = this.getParameterParser();
        HttpServletRequest request = this.getRequest();
        if (parameters != null && parameters.getRequest() != request) {
            parameters.setRequest(request);
        }
        return parameters;
    }

    @Override
    public CookieParser getCookies() {
        CookieParser cookies = this.getCookieParser();
        HttpServletRequest request = this.getRequest();
        if (cookies != null && cookies.getRequest() != request) {
            cookies.setData(request, this.getResponse());
        }
        return cookies;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.get(Turbine.class, HttpServletRequest.class);
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.get(Turbine.class, HttpServletResponse.class);
    }

    @Override
    public HttpSession getSession() {
        return this.getRequest().getSession();
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.get(Turbine.class, ServletConfig.class);
    }

    @Override
    public ServletContext getServletContext() {
        return this.get(Turbine.class, ServletContext.class);
    }

    @Override
    public <A extends AccessControlList> A getACL() {
        AccessControlList acl = this.get(Turbine.class, AccessControlList.class);
        return (A)acl;
    }

    @Override
    public void setACL(AccessControlList acl) {
        this.get(Turbine.class).put(AccessControlList.class, acl);
    }

    @Override
    @Deprecated
    public boolean isPageSet() {
        return this.pageSet;
    }

    @Override
    @Deprecated
    public Document getPage() {
        this.pageSet = true;
        if (this.page == null) {
            this.page = new Document();
        }
        return this.page;
    }

    @Override
    public boolean hasAction() {
        return StringUtils.isNotEmpty((String)this.action) && !this.action.equalsIgnoreCase("null");
    }

    @Override
    public String getAction() {
        return this.hasAction() ? this.action : "";
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public String getLayout() {
        if (this.layout == null) {
            this.layout = TurbineTemplate.getDefaultLayoutName(this);
            if (this.layout == null) {
                this.layout = "DefaultLayout";
            }
        }
        return this.layout;
    }

    @Override
    public void setLayout(String layout) {
        this.layout = layout;
    }

    @Override
    public String getLayoutTemplate() {
        return this.getTemplateInfo().getLayoutTemplate();
    }

    @Override
    public void setLayoutTemplate(String layout) {
        this.getTemplateInfo().setLayoutTemplate(layout);
    }

    @Override
    public boolean hasScreen() {
        return StringUtils.isNotEmpty((String)this.screen);
    }

    @Override
    public String getScreen() {
        return this.hasScreen() ? this.screen : "";
    }

    @Override
    public void setScreen(String screen) {
        this.screen = screen;
    }

    @Override
    public String getScreenTemplate() {
        return this.getTemplateInfo().getScreenTemplate();
    }

    @Override
    public void setScreenTemplate(String screen) {
        this.getTemplateInfo().setScreenTemplate(screen);
    }

    @Override
    public String getTemplateEncoding() {
        return this.templateEncoding;
    }

    @Override
    public void setTemplateEncoding(String encoding) {
        this.templateEncoding = encoding;
    }

    @Override
    public TemplateInfo getTemplateInfo() {
        TemplateInfo templateInfo = this.get(Turbine.class, TemplateInfo.class);
        if (templateInfo == null) {
            templateInfo = new TemplateInfo(this);
            this.get(Turbine.class).put(TemplateInfo.class, templateInfo);
        }
        return templateInfo;
    }

    @Override
    public boolean hasMessage() {
        StringElement message = this.get(Turbine.class, StringElement.class);
        return message != null && StringUtils.isNotEmpty((String)message.toString());
    }

    @Override
    public String getMessage() {
        StringElement message = this.get(Turbine.class, StringElement.class);
        return message == null ? null : message.toString();
    }

    @Override
    public void setMessage(String msg) {
        this.get(Turbine.class).put(StringElement.class, new StringElement(msg));
    }

    @Override
    public void addMessage(String msg) {
        this.addMessage((Element)new StringElement(msg));
    }

    @Override
    public StringElement getMessageAsHTML() {
        return this.get(Turbine.class, StringElement.class);
    }

    @Override
    public void setMessage(Element msg) {
        this.get(Turbine.class).put(StringElement.class, new StringElement(msg));
    }

    @Override
    public void addMessage(Element msg) {
        if (msg != null) {
            StringElement message = this.get(Turbine.class, StringElement.class);
            if (message != null) {
                message.addElement(msg);
            } else {
                this.setMessage(msg);
            }
        }
    }

    @Override
    public void unsetMessage() {
        this.get(Turbine.class).remove(StringElement.class);
    }

    @Override
    public FormMessages getMessages() {
        FormMessages messages = this.get(Turbine.class, FormMessages.class);
        if (messages == null) {
            messages = new FormMessages();
            this.setMessages(messages);
        }
        return messages;
    }

    @Override
    public void setMessages(FormMessages msgs) {
        this.get(Turbine.class).put(FormMessages.class, msgs);
    }

    @Override
    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean userExists() {
        Object user = this.getUserFromSession();
        this.get(Turbine.class).put(User.class, user);
        return user != null;
    }

    @Override
    public <T extends User> T getUser() {
        User user = this.get(Turbine.class, User.class);
        return (T)user;
    }

    public void setUser(User user) {
        log.debug((Object)("user set: " + user.getName()));
        this.get(Turbine.class).put(User.class, user);
    }

    @Override
    public <T extends User> T getUserFromSession() {
        return DefaultTurbineRunData.getUserFromSession(this.getSession());
    }

    @Override
    public boolean removeUserFromSession() {
        return DefaultTurbineRunData.removeUserFromSession(this.getSession());
    }

    @Override
    @Deprecated
    public boolean isOutSet() {
        return this.outSet;
    }

    @Override
    public PrintWriter getOut() throws IOException {
        if (this.out == null) {
            this.setOut(this.getResponse().getWriter());
        }
        this.pageSet = false;
        this.outSet = true;
        return this.out;
    }

    @Override
    public void declareDirectResponse() {
        this.outSet = true;
        this.pageSet = false;
    }

    @Override
    public Locale getLocale() {
        Locale locale = this.get(Turbine.class, Locale.class);
        if (locale == null) {
            locale = DefaultTurbineRunData.getDefaultLocale();
        }
        return locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.get(Turbine.class).put(Locale.class, locale);
        ParameterParser parameters = this.get(Turbine.class, ParameterParser.class);
        CookieParser cookies = this.get(Turbine.class, CookieParser.class);
        if (parameters != null) {
            parameters.setLocale(locale);
        }
        if (cookies != null) {
            cookies.setLocale(locale);
        }
    }

    @Override
    public String getCharSet() {
        log.debug((Object)"getCharSet()");
        if (StringUtils.isEmpty((String)this.charSet)) {
            log.debug((Object)"Charset was null!");
            return this.getDefaultCharSet();
        }
        return this.charSet;
    }

    @Override
    public void setCharSet(String charSet) {
        log.debug((Object)("setCharSet(" + charSet + ")"));
        this.charSet = charSet;
    }

    @Override
    public String getContentType() {
        if (StringUtils.isNotEmpty((String)this.contentType)) {
            if (StringUtils.isEmpty((String)this.charSet)) {
                if (this.contentType.startsWith("text/")) {
                    return this.contentType + "; charset=" + this.getDefaultCharSet();
                }
                return this.contentType;
            }
            return this.contentType + "; charset=" + this.charSet;
        }
        return "";
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getRedirectURI() {
        return this.redirectURI == null ? "" : this.redirectURI;
    }

    @Override
    public void setRedirectURI(String ruri) {
        this.redirectURI = ruri;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public SystemError[] getSystemErrors() {
        SystemError[] result = new SystemError[this.errors.size()];
        this.errors.toArray(result);
        return result;
    }

    @Override
    public void setSystemError(SystemError err) {
        this.errors.add(err);
    }

    @Override
    public Map<String, Context> getJNDIContexts() {
        if (this.jndiContexts == null) {
            this.jndiContexts = new HashMap<String, Context>();
        }
        return this.jndiContexts;
    }

    @Override
    public void setJNDIContexts(Map<String, Context> contexts) {
        this.jndiContexts = contexts;
    }

    @Override
    public String getServerScheme() {
        return this.getServerData().getServerScheme();
    }

    @Override
    public String getServerName() {
        return this.getServerData().getServerName();
    }

    @Override
    public int getServerPort() {
        return this.getServerData().getServerPort();
    }

    @Override
    public String getContextPath() {
        return this.getServerData().getContextPath();
    }

    @Override
    public String getScriptName() {
        return this.getServerData().getScriptName();
    }

    @Override
    public ServerData getServerData() {
        return this.get(Turbine.class, ServerData.class);
    }

    @Override
    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.remoteAddr = this.getRequest().getRemoteAddr();
        }
        return this.remoteAddr;
    }

    @Override
    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = this.getRequest().getRemoteHost();
        }
        return this.remoteHost;
    }

    @Override
    public String getUserAgent() {
        if (StringUtils.isEmpty((String)this.userAgent)) {
            this.userAgent = this.getRequest().getHeader("User-Agent");
        }
        return this.userAgent;
    }

    @Override
    public void populate() {
        Object user = this.getUserFromSession();
        this.get(Turbine.class).put(User.class, user);
        if (user != null) {
            user.setLastAccessDate();
            user.incrementAccessCounter();
            user.incrementAccessCounterForSession();
        }
    }

    @Override
    public void save() {
        this.getSession().setAttribute("turbine.user", this.getUser());
    }

    @Override
    public String getStackTrace() {
        return this.stackTrace;
    }

    @Override
    public Throwable getStackTraceException() {
        return this.stackTraceException;
    }

    @Override
    public void setStackTrace(String trace, Throwable exp) {
        this.stackTrace = trace;
        this.stackTraceException = exp;
    }

    @Override
    public void setDebugVariable(String name, Object value) {
        this.debugVariables.put(name, value);
    }

    @Override
    public Map<String, Object> getDebugVariables() {
        return this.debugVariables;
    }

    @Override
    public ParameterParser getParameterParser() {
        return this.get(Turbine.class, ParameterParser.class);
    }

    @Override
    public CookieParser getCookieParser() {
        return this.get(Turbine.class, CookieParser.class);
    }

    @Deprecated
    protected void setOut(PrintWriter out) {
        this.out = out;
    }

    protected void setServerScheme(String serverScheme) {
        this.getServerData().setServerScheme(serverScheme);
    }

    protected void setServerName(String serverName) {
        this.getServerData().setServerName(serverName);
    }

    protected void setServerPort(int port) {
        this.getServerData().setServerPort(port);
    }

    protected void setContextPath(String contextPath) {
        this.getServerData().setContextPath(contextPath);
    }

    protected void setScriptName(String scriptName) {
        this.getServerData().setScriptName(scriptName);
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

