/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.ldap;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.ldap.LDAPSecurityConstants;

public class LDAPUser
implements User {
    private static Log log = LogFactory.getLog(LDAPUser.class);
    private Date createDate = new Date();
    private Date lastAccessDate = null;
    private int timeout = 15;
    private Hashtable permStorage = null;
    private Hashtable tempStorage = new Hashtable(10);

    public LDAPUser() {
        this.permStorage = new Hashtable(10);
        this.setHasLoggedIn(Boolean.FALSE);
    }

    public void setLDAPAttributes(Attributes attribs) throws NamingException {
        Attribute attr;
        String attrName = LDAPSecurityConstants.getUserIdAttribute();
        if (attrName == null || (attr = attribs.get(attrName)) == null || attr.get() != null) {
            // empty if block
        }
        if ((attrName = LDAPSecurityConstants.getNameAttribute()) != null) {
            attr = attribs.get(attrName);
            if (attr != null && attr.get() != null) {
                this.setName(attr.get().toString());
            }
        } else {
            log.error((Object)"There is no LDAP attribute for the username.");
        }
        if ((attrName = LDAPSecurityConstants.getFirstNameAttribute()) != null && (attr = attribs.get(attrName)) != null && attr.get() != null) {
            this.setFirstName(attr.get().toString());
        }
        if ((attrName = LDAPSecurityConstants.getLastNameAttribute()) != null && (attr = attribs.get(attrName)) != null && attr.get() != null) {
            this.setLastName(attr.get().toString());
        }
        if ((attrName = LDAPSecurityConstants.getEmailAttribute()) != null && (attr = attribs.get(attrName)) != null && attr.get() != null) {
            this.setEmail(attr.get().toString());
        }
    }

    public Attributes getLDAPAttributes() throws NamingException {
        BasicAttribute attr;
        Object value;
        BasicAttributes attribs = new BasicAttributes();
        String attrName = "objectClass";
        if (attrName != null && (value = "turbineUser") != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getUserIdAttribute()) != null && (value = this.getIdAsObj()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getNameAttribute()) != null && (value = this.getName()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getFirstNameAttribute()) != null && (value = this.getFirstName()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getLastNameAttribute()) != null && (value = this.getLastName()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getEmailAttribute()) != null && (value = this.getEmail()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getPasswordAttribute()) != null && (value = this.getPassword()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        return attribs;
    }

    public String getDN() {
        String filterAttribute = LDAPSecurityConstants.getNameAttribute();
        String userBaseSearch = LDAPSecurityConstants.getBaseSearch();
        String userName = this.getName();
        String dn = filterAttribute + "=" + userName + "," + userBaseSearch;
        return dn;
    }

    @Override
    public int getAccessCounterForSession() {
        try {
            return (Integer)this.getTemp("_session_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getAccessCounter() {
        try {
            return (Integer)this.getPerm("_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public Date getCreateDate() {
        return this.createDate;
    }

    @Override
    public String getConfirmed() {
        String tmp = null;
        tmp = (String)this.getPerm("CONFIRM_VALUE");
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    @Override
    public String getEmail() {
        String tmp = null;
        tmp = (String)this.getPerm("EMAIL");
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    @Override
    public Date getLastAccessDate() {
        if (this.lastAccessDate == null) {
            this.setLastAccessDate();
        }
        return this.lastAccessDate;
    }

    @Override
    public Date getLastLogin() {
        return (Date)this.getPerm("LAST_LOGIN");
    }

    @Override
    public String getPassword() {
        return (String)this.getPerm("PASSWORD_VALUE");
    }

    @Override
    public Object getPerm(String name) {
        return this.permStorage.get(name);
    }

    @Override
    public Object getPerm(String name, Object def) {
        try {
            Object val = this.permStorage.get(name);
            if (val == null) {
                return def;
            }
            return val;
        }
        catch (Exception e) {
            return def;
        }
    }

    public Hashtable getPermStorage() {
        if (this.permStorage == null) {
            this.permStorage = new Hashtable();
        }
        return this.permStorage;
    }

    @Override
    public Object getTemp(String name) {
        return this.tempStorage.get(name);
    }

    @Override
    public Object getTemp(String name, Object def) {
        Object val;
        try {
            val = this.tempStorage.get(name);
            if (val == null) {
                val = def;
            }
        }
        catch (Exception e) {
            val = def;
        }
        return val;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public String getFirstName() {
        String tmp = null;
        tmp = (String)this.getPerm("FIRST_NAME");
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    @Override
    public String getLastName() {
        String tmp = null;
        tmp = (String)this.getPerm("LAST_NAME");
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    @Override
    public boolean hasLoggedIn() {
        Boolean tmp = this.getHasLoggedIn();
        return tmp != null && tmp != false;
    }

    @Override
    public boolean isConfirmed() {
        return ((String)this.getTemp("CONFIRM_VALUE", "")).equals("CONFIRMED");
    }

    @Override
    public void incrementAccessCounter() {
        this.setAccessCounter(this.getAccessCounter() + 1);
    }

    @Override
    public void incrementAccessCounterForSession() {
        this.setAccessCounterForSession(this.getAccessCounterForSession() + 1);
    }

    @Override
    public Object removeTemp(String name) {
        return this.tempStorage.remove(name);
    }

    @Override
    public void setAccessCounter(int cnt) {
        this.setPerm("_access_counter", new Integer(cnt));
    }

    @Override
    public void setAccessCounterForSession(int cnt) {
        this.setTemp("_session_access_counter", new Integer(cnt));
    }

    @Override
    public void setConfirmed(String confirm) {
        this.getPerm("CONFIRM_VALUE", confirm);
    }

    @Override
    public void setLastAccessDate() {
        this.lastAccessDate = new Date();
    }

    @Override
    public void setCreateDate(Date date) {
        this.createDate = date;
    }

    @Override
    public void setEmail(String email) {
        this.setPerm("EMAIL", email);
    }

    @Override
    public void setFirstName(String fname) {
        this.setPerm("FIRST_NAME", fname);
    }

    @Override
    public void setLastLogin(Date date) {
        this.setPerm("LAST_LOGIN", date);
    }

    @Override
    public void setLastName(String lname) {
        this.setPerm("LAST_NAME", lname);
    }

    @Override
    public void setPassword(String password) {
        this.setPerm("PASSWORD_VALUE", password);
    }

    @Override
    public void setPerm(String name, Object value) {
        this.permStorage.put(name, value);
    }

    public void setPermStorage(Hashtable stuff) {
        this.permStorage = stuff;
    }

    public Hashtable getTempStorage() {
        if (this.tempStorage == null) {
            this.tempStorage = new Hashtable();
        }
        return this.tempStorage;
    }

    public void setTempStorage(Hashtable storage) {
        this.tempStorage = storage;
    }

    private Boolean getHasLoggedIn() {
        return (Boolean)this.getTemp("_has_logged_in");
    }

    @Override
    public void setHasLoggedIn(Boolean value) {
        this.setTemp("_has_logged_in", value);
    }

    @Override
    public void setTemp(String name, Object value) {
        this.tempStorage.put(name, value);
    }

    public void setTimeout(int time) {
        this.timeout = time;
    }

    @Override
    public void updateLastLogin() throws Exception {
        this.setPerm("LAST_LOGIN", new Date());
    }

    public void valueBound(HttpSessionBindingEvent hsbe) {
    }

    public void valueUnbound(HttpSessionBindingEvent hsbe) {
        try {
            if (this.hasLoggedIn()) {
                TurbineSecurity.saveUser(this);
            }
        }
        catch (Exception e) {
            log.error((Object)("BaseUser.valueUnbobund(): " + e.getMessage()));
            log.error((Object)e);
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(ostr, true));
            String stackTrace = ostr.toString();
            System.out.println(stackTrace);
        }
    }

    @Override
    public String getName() {
        String tmp = null;
        tmp = (String)this.getPerm("LOGIN_NAME");
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    @Override
    public void setName(String name) {
        this.setPerm("LOGIN_NAME", name);
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public Integer getIdAsObj() {
        return new Integer(0);
    }

    @Override
    public void setId(int id) {
    }

    public void save() throws Exception {
        if (TurbineSecurity.accountExists(this)) {
            TurbineSecurity.saveUser(this);
        } else {
            TurbineSecurity.addUser(this, this.getPassword());
        }
    }

    public void save(Connection conn) throws Exception {
        throw new Exception("not implemented");
    }

    public void save(String dbname) throws Exception {
        throw new Exception("not implemented");
    }
}

