/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.assemblerbroker.util.python;

import java.io.File;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;
import org.python.core.Py;
import org.python.util.PythonInterpreter;

public abstract class PythonBaseFactory
implements AssemblerFactory {
    public static final String PYTHON_PATH = "python.path";
    public static final String PYTHON_CONFIG_FILE = "conf.py";
    private static Log log = LogFactory.getLog((Class)PythonBaseFactory.class);
    private Configuration conf = TurbineAssemblerBroker.getService().getConfiguration();

    public Assembler getAssembler(String subDirectory, String name) throws Exception {
        String path = this.conf.getString(PYTHON_PATH);
        if (StringUtils.isEmpty((String)path)) {
            throw new Exception("Python path not found - check your Properties");
        }
        log.debug((Object)("Screen name for JPython: " + name));
        Assembler assembler = null;
        String confName = path + "/" + PYTHON_CONFIG_FILE;
        StringBuffer fName = new StringBuffer();
        fName.append(path);
        fName.append("/");
        fName.append(subDirectory);
        fName.append("/");
        fName.append(name.toLowerCase());
        fName.append(".py");
        File f = new File(fName.toString());
        if (f.exists()) {
            try {
                PythonInterpreter interp = new PythonInterpreter();
                Py.getSystemState().setClassLoader(this.getClass().getClassLoader());
                interp.exec("import sys");
                interp.execfile(confName);
                interp.execfile(fName.toString());
                try {
                    interp.exec("scr = " + name + "()");
                }
                catch (Throwable e) {
                    throw new Exception("\nCannot create an instance of the python class.\nYou probably gave your class the wrong name.\nYour class should have the same name as your filename.\nFilenames should be all lowercase and classnames should start with a capital.\nExpected class name: " + name + "\n");
                }
                assembler = (Assembler)interp.get("scr", Assembler.class);
            }
            catch (Exception e) {
                log.error((Object)"PYTHON SCRIPT SCREEN LOADER ERROR:", (Throwable)e);
                throw e;
            }
        }
        return assembler;
    }
}

