/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger.tool;

import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerManager;

public class Consumer {
    private Messenger messenger;

    public static void main(String[] args) {
        block4: {
            try {
                Consumer client = new Consumer();
                client.run(args);
            }
            catch (JMSException e) {
                System.out.println("Caught: " + (Object)((Object)e));
                Exception linked = e.getLinkedException();
                if (linked != null) {
                    System.out.println("Underlying exception: " + linked);
                    linked.printStackTrace();
                    break block4;
                }
                e.printStackTrace();
            }
            catch (Exception e) {
                System.out.println("Caught: " + e);
                e.printStackTrace();
            }
        }
    }

    public void run(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: Consumer messengerName destination [fileName]");
            System.out.println("If no fileName is provided then the current input stream is used");
            return;
        }
        String name = args[0];
        String subject = args[1];
        this.messenger = MessengerManager.get(name);
        if (this.messenger == null) {
            throw new JMSException("No such messenger called: " + name);
        }
        Destination destination = this.messenger.getDestination(subject);
        if (destination == null) {
            throw new JMSException("Could not find destination: " + subject);
        }
        OutputStreamWriter writer = args.length > 2 ? new FileWriter(args[2]) : new OutputStreamWriter(System.out);
        Message message = this.messenger.receive(destination);
        this.writeMessage(message, writer);
        this.messenger.close();
    }

    protected void writeMessage(Message message, Writer out) throws Exception {
        PrintWriter writer = new PrintWriter(out);
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            writer.println(textMessage.getText());
        }
        writer.close();
    }
}

