/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.collections;

import java.util.AbstractList;
import java.util.ListIterator;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import ojb.odmg.collections.DListEntry;
import ojb.odmg.collections.DListImpl;

class DListIterator
implements ListIterator {
    protected ListIterator iter;
    private DListImpl dlist;
    private DListEntry currentEntry = null;

    public DListIterator(DListImpl list) {
        this.dlist = list;
        this.iter = ((AbstractList)list.getElements()).listIterator();
    }

    public DListIterator(DListImpl list, int index) {
        this.dlist = list;
        this.iter = ((AbstractList)list.getElements()).listIterator(index);
    }

    public void add(Object o) {
        DListEntry entry = new DListEntry(this.dlist, o);
        entry.setPosition(this.nextIndex() - 1);
        this.iter.add(entry);
        TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
        tx.lock(entry, 4);
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public boolean hasPrevious() {
        return this.iter.hasPrevious();
    }

    public Object next() {
        this.currentEntry = (DListEntry)this.iter.next();
        return this.currentEntry.getRealSubject();
    }

    public int nextIndex() {
        return this.iter.nextIndex();
    }

    public Object previous() {
        this.currentEntry = (DListEntry)this.iter.previous();
        return this.currentEntry.getRealSubject();
    }

    public int previousIndex() {
        return this.iter.previousIndex();
    }

    public void remove() {
        this.iter.remove();
        TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
        tx.markDelete(this.currentEntry);
        this.currentEntry = null;
    }

    public void set(Object o) {
        this.currentEntry.setRealSubject(o);
    }
}

