/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.api;

import java.util.List;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathFilterSet
extends FilterSet<PathFilter> {
    public static final String TYPE_CLEANUP = "cleanup";
    public static final PathFilterSet INCLUDE_ALL = (PathFilterSet)new PathFilterSet().addInclude(PathFilter.ALL).seal();
    public static final PathFilterSet EXCLUDE_ALL = (PathFilterSet)new PathFilterSet().addExclude(PathFilter.ALL).seal();
    private boolean onlyRelativePatterns;
    @Nullable
    private String type;

    public PathFilterSet() {
    }

    public PathFilterSet(@NotNull String root) {
        super(root);
    }

    public boolean contains(@NotNull String path) {
        if (!this.covers(path)) {
            return false;
        }
        List entries = this.getEntries();
        if (entries.isEmpty()) {
            return true;
        }
        boolean result = !entries.get((int)0).include;
        for (FilterSet.Entry entry : entries) {
            if (!((PathFilter)entry.filter).matches(path)) continue;
            result = entry.include;
        }
        return result;
    }

    @Override
    @NotNull
    public FilterSet<PathFilter> seal() {
        if (!this.isSealed()) {
            super.seal();
            this.onlyRelativePatterns = true;
            for (FilterSet.Entry entry : this.getEntries()) {
                if (entry.include && !((PathFilter)entry.filter).isAbsolute()) continue;
                this.onlyRelativePatterns = false;
                break;
            }
        }
        return this;
    }

    @NotNull
    public PathFilterSet translate(@Nullable PathMapping mapping) {
        if (mapping == null) {
            return this;
        }
        PathFilterSet mapped = new PathFilterSet(mapping.map(this.getRoot()));
        mapped.setImportMode(this.getImportMode());
        for (FilterSet.Entry e : this.getEntries()) {
            if (e.isInclude()) {
                mapped.addInclude(((PathFilter)e.getFilter()).translate(mapping));
                continue;
            }
            mapped.addExclude(((PathFilter)e.getFilter()).translate(mapping));
        }
        mapped.seal();
        return mapped;
    }

    public boolean hasOnlyRelativePatterns() {
        this.seal();
        return this.onlyRelativePatterns;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @NotNull
    public PathFilterSet setType(@Nullable String type) {
        this.type = type;
        return this;
    }
}

