/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.sling.feature.cpconverter.accesscontrol.AccessControlEntry;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.shared.AbstractJcrNodeParser;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

abstract class AbstractPolicyParser
extends AbstractJcrNodeParser<Boolean> {
    static final String REP_RESTRICTIONS = "rep:Restrictions";
    static final String REP_PRINCIPAL_NAME = "rep:principalName";
    static final String REP_PRIVILEGES = "rep:privileges";
    private static final Pattern typeIndicatorPattern = Pattern.compile("\\{[^\\}]+\\}\\[(.+)\\]");
    private final RepoPath repositoryPath;
    final TransformerHandler handler;
    final AclManager aclManager;
    boolean onRepAclNode = false;
    boolean hasRejectedNodes = false;

    AbstractPolicyParser(@NotNull String primaryType, @NotNull RepoPath repositoryPath, @NotNull AclManager aclManager, @NotNull TransformerHandler handler) {
        super(primaryType);
        this.handler = handler;
        this.repositoryPath = repositoryPath;
        this.aclManager = aclManager;
    }

    @NotNull
    static List<String> extractValues(@Nullable String expression) {
        if (expression == null || expression.isEmpty()) {
            return Collections.emptyList();
        }
        String valuesString = expression;
        Matcher matcher = typeIndicatorPattern.matcher(expression);
        if (matcher.matches()) {
            valuesString = matcher.group(1);
        }
        ArrayList<String> vs = new ArrayList<String>();
        for (String v : valuesString.split(",")) {
            vs.add(v.trim());
        }
        return vs;
    }

    void addRestrictions(@NotNull AccessControlEntry ace, @NotNull Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            List<String> vs;
            String name = attributes.getQName(i);
            if (!this.isRestriction(name) || (vs = AbstractPolicyParser.extractValues(attributes.getValue(name))).isEmpty()) continue;
            ace.addRestriction(name, vs);
        }
    }

    boolean isRestriction(@NotNull String attributeName) {
        return !REP_PRINCIPAL_NAME.equals(attributeName) && !REP_PRIVILEGES.equals(attributeName) && !attributeName.startsWith("jcr:");
    }

    AccessControlEntry createEntry(boolean isAllow, @NotNull Attributes attributes) {
        return new AccessControlEntry(isAllow, Objects.requireNonNull(AbstractPolicyParser.extractValues(attributes.getValue(REP_PRIVILEGES))), this.repositoryPath);
    }

    @Override
    public void startDocument() throws SAXException {
        this.handler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    @Override
    protected void onJcrRootElement(String uri, String localName, String qName, Attributes attributes) {
        this.onRepAclNode = true;
    }

    @Override
    protected Boolean getParsingResult() {
        return this.hasRejectedNodes;
    }
}

