// Copyright 2009 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Mock matchers for event related arguments.
 */

goog.setTestOnly('goog.testing.events.EventMatcher');
goog.provide('goog.testing.events.EventMatcher');

goog.require('goog.events.Event');
goog.require('goog.testing.mockmatchers.ArgumentMatcher');



/**
 * A matcher that verifies that an argument is a `goog.events.Event` of a
 * particular type.
 * @param {string} type The single type the event argument must be of.
 * @constructor
 * @extends {goog.testing.mockmatchers.ArgumentMatcher}
 * @final
 */
goog.testing.events.EventMatcher = function(type) {
  goog.testing.mockmatchers.ArgumentMatcher.call(this, function(obj) {
    return obj instanceof goog.events.Event && obj.type == type;
  }, 'isEventOfType(' + type + ')');
};
goog.inherits(
    goog.testing.events.EventMatcher,
    goog.testing.mockmatchers.ArgumentMatcher);
