/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.Filter;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;
import org.apache.pluto.container.om.portlet.impl.DisplayNameImpl;
import org.apache.pluto.container.om.portlet.impl.InitParamImpl;

public class FilterImpl
implements Filter {
    private final String filterName;
    private final ArrayList<String> lifecycles = new ArrayList();
    private final List<Description> descs = new ArrayList<Description>();
    private final List<DisplayName> dispNames = new ArrayList<DisplayName>();
    private final Map<String, InitParam> initParams = new LinkedHashMap<String, InitParam>();
    private String fclass = "";
    private int ordinal;
    private boolean ordinalSet = false;

    public FilterImpl(Filter fi) {
        this.filterName = fi.getFilterName();
        this.fclass = fi.getFilterClass();
        for (String lc : fi.getLifecycles()) {
            this.lifecycles.add(new String(lc));
        }
        for (Description desc : fi.getDescriptions()) {
            this.descs.add(new DescriptionImpl(desc));
        }
        for (DisplayName disp : fi.getDisplayNames()) {
            this.dispNames.add(new DisplayNameImpl(disp));
        }
        for (InitParam ip : fi.getInitParams()) {
            this.initParams.put(ip.getParamName(), new InitParamImpl(ip));
        }
        this.ordinal = fi.getOrdinal();
        this.ordinalSet = fi.isOrdinalSet();
    }

    public FilterImpl(String fn) {
        this.filterName = fn;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public List<String> getLifecycles() {
        return new ArrayList<String>(this.lifecycles);
    }

    public void addLifecycle(String lc) {
        this.lifecycles.add(lc);
    }

    public Description getDescription(Locale locale) {
        DescriptionImpl ret = null;
        for (Description item : this.descs) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DescriptionImpl(item);
        }
        return ret;
    }

    public List<Description> getDescriptions() {
        return new ArrayList<Description>(this.descs);
    }

    public void addDescription(Description desc) {
        this.descs.add(desc);
    }

    public DisplayName getDisplayName(Locale locale) {
        DisplayNameImpl ret = null;
        for (DisplayName item : this.dispNames) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DisplayNameImpl(item);
        }
        return ret;
    }

    public List<DisplayName> getDisplayNames() {
        return new ArrayList<DisplayName>(this.dispNames);
    }

    public void addDisplayName(DisplayName desc) {
        this.dispNames.add(desc);
    }

    public String getFilterClass() {
        return this.fclass;
    }

    public void setFilterClass(String filterClass) {
        this.fclass = filterClass;
    }

    public InitParam getInitParam(String paramName) {
        return this.initParams.get(paramName);
    }

    public List<InitParam> getInitParams() {
        return new ArrayList<InitParam>(this.initParams.values());
    }

    public void addInitParam(InitParam ip) {
        this.initParams.put(ip.getParamName(), ip);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
        this.ordinalSet = true;
    }

    public boolean isOrdinalSet() {
        return this.ordinalSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filterName == null ? 0 : this.filterName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterImpl other = (FilterImpl)obj;
        return !(this.filterName == null ? other.filterName != null : !this.filterName.equals(other.filterName));
    }
}

