/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.frameworks;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.portals.bridges.frameworks.Forwarder;
import org.apache.portals.bridges.frameworks.model.ModelBean;
import org.apache.portals.bridges.frameworks.model.PortletApplicationModel;
import org.apache.portals.bridges.frameworks.spring.PortletApplicationModelImpl;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;

public class GenericFrameworkPortlet
extends GenericVelocityPortlet {
    private static final String INITPARAM_SPRING_CONFIG = "spring-configuration";
    private static final String INITPARAM_VALIDATOR_CONFIG = "validator-configuration";
    private static final String PREFS_SUFFIX = ".prefs";
    private static final String SESSION_ERROR_MESSAGES = "portals.bridges.framework.errors";
    private static final Class[] VELOCITY_PORTLET_ACTION_SIGNATURE = new Class[]{ActionRequest.class, ActionResponse.class, Object.class};
    private static PortletApplicationModel model = null;
    private static Object semaphore = new Object();

    public void setExternalSupport(Map map) {
        model.setExternalSupport(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        String springConfig = this.getInitParameter(INITPARAM_SPRING_CONFIG);
        if (springConfig == null) {
            throw new PortletException("Spring Configuration file not specified");
        }
        String validatorConfig = this.getInitParameter(INITPARAM_VALIDATOR_CONFIG);
        Object object = semaphore;
        synchronized (object) {
            if (null == model) {
                model = new PortletApplicationModelImpl(springConfig, validatorConfig);
                model.init(config);
            }
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String view = this.determineLogicalView((PortletRequest)request);
        Object bean = null;
        ModelBean mb = model.getModelBean(view);
        bean = mb.getBeanType() == 1 ? this.formToPrefs(request, view, mb) : this.formToBean(request, view, mb);
        String forward = null;
        ResourceBundle bundle = this.getPortletConfig().getResourceBundle(request.getLocale());
        Map errors = model.validate(bean, view, bundle);
        if (errors.isEmpty()) {
            request.getPortletSession().removeAttribute(SESSION_ERROR_MESSAGES, 2);
            String action = request.getParameter("portlet.action");
            if (null == action) {
                if (mb.getBeanType() == 1) {
                    this.storePreferences((PortletRequest)request, (Map)bean);
                }
                forward = model.getForward(view, "success");
            } else {
                String actionForward = this.invokeVelocityPortletAction(action, request, response, bean);
                forward = model.getForward(actionForward);
            }
        } else {
            request.getPortletSession().setAttribute(SESSION_ERROR_MESSAGES, (Object)errors, 2);
            forward = model.getForward(view, "failure");
        }
        this.clearBeanFromSession((PortletRequest)request, mb);
        this.forwardToView(request, response, forward);
    }

    protected void forwardToView(ActionRequest request, ActionResponse response, String forward) {
        if (forward == null) {
            return;
        }
        String logicalView = null;
        PortletMode newMode = null;
        StringTokenizer tokenizer = new StringTokenizer(forward, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.startsWith("mode:")) {
                newMode = this.setPortletMode(response, token.substring("mode:".length()));
                continue;
            }
            if (token.startsWith("state:")) {
                this.setWindowState(response, token.substring("state:".length()));
                continue;
            }
            logicalView = token;
        }
        if (logicalView != null) {
            this.setLogicalView((PortletRequest)request, (PortletResponse)response, logicalView, newMode);
        }
    }

    private void setWindowState(ActionResponse response, String forward) {
        try {
            if (forward.equals("maximized")) {
                response.setWindowState(WindowState.MAXIMIZED);
            } else if (forward.equals("minimized")) {
                response.setWindowState(WindowState.MINIMIZED);
            } else if (forward.equals("normal")) {
                response.setWindowState(WindowState.NORMAL);
            }
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
    }

    private PortletMode setPortletMode(ActionResponse response, String forward) {
        PortletMode mode = null;
        try {
            if (forward.equals("view")) {
                response.setPortletMode(PortletMode.VIEW);
                mode = PortletMode.VIEW;
            } else if (forward.equals("edit")) {
                response.setPortletMode(PortletMode.EDIT);
                mode = PortletMode.EDIT;
            } else if (forward.equals("help")) {
                response.setPortletMode(PortletMode.HELP);
                mode = PortletMode.HELP;
            }
        }
        catch (PortletModeException e) {
            // empty catch block
        }
        return mode;
    }

    protected void storePreferences(PortletRequest request, Map bean) throws IOException, PortletException {
        String key = "none";
        try {
            PortletPreferences prefs = request.getPreferences();
            Iterator it = bean.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                key = (String)entry.getKey();
                if (prefs.isReadOnly(key)) continue;
                prefs.setValue(key, (String)entry.getValue());
            }
            prefs.store();
        }
        catch (ReadOnlyException roe) {
            throw new PortletException("Failed to set preference " + key + ", value is readonly");
        }
    }

    protected String determineLogicalView(PortletRequest request) throws PortletException {
        String view = null;
        PortletSession session = request.getPortletSession();
        if (request.getPortletMode().equals((Object)PortletMode.VIEW)) {
            view = request.getParameter("bridges.view.view");
            if (view == null && (view = (String)session.getAttribute("bridges.view.view")) == null) {
                view = this.getDefaultViewPage();
            }
        } else if (request.getPortletMode().equals((Object)PortletMode.EDIT)) {
            view = request.getParameter("bridges.view.edit");
            if (view == null && (view = (String)session.getAttribute("bridges.view.edit")) == null) {
                view = this.getDefaultEditPage();
            }
        } else if (request.getPortletMode().equals((Object)PortletMode.HELP) && (view = request.getParameter("bridges.view.help")) == null && (view = (String)session.getAttribute("bridges.view.help")) == null) {
            view = this.getDefaultHelpPage();
        }
        if (null == view) {
            throw new PortletException("Portlet error: cant find view resource for portlet: " + this.getPortletName());
        }
        return view;
    }

    protected void setLogicalView(PortletRequest request, PortletResponse response, String view, PortletMode newMode) {
        PortletSession session = request.getPortletSession();
        if (request.getPortletMode().equals((Object)PortletMode.VIEW)) {
            session.setAttribute("bridges.view.view", (Object)view);
        } else if (request.getPortletMode().equals((Object)PortletMode.EDIT)) {
            session.setAttribute("bridges.view.edit", (Object)view);
        } else if (request.getPortletMode().equals((Object)PortletMode.HELP)) {
            session.setAttribute("bridges.view.help", (Object)view);
        }
    }

    protected Object formToBean(ActionRequest request, String view, ModelBean mb) throws PortletException {
        Object bean = this.getBeanFromSession((PortletRequest)request, mb);
        if (bean == null) {
            bean = model.createBean(mb);
            if (bean == null) {
                throw new PortletException("Portlet Action error in creating bean for view: " + view);
            }
            this.putBeanInSession((PortletRequest)request, mb, bean);
        }
        Map params = request.getParameterMap();
        try {
            BeanUtils.populate((Object)bean, (Map)params);
        }
        catch (Exception e) {
            throw new PortletException("Portlet Action error in  populating bean: " + mb.getBeanName(), (Throwable)e);
        }
        return bean;
    }

    protected Object formToPrefs(ActionRequest request, String view, ModelBean mb) throws PortletException {
        Map params = request.getParameterMap();
        Map bean = (Map)request.getPortletSession().getAttribute(view + PREFS_SUFFIX);
        if (bean == null) {
            PortletPreferences prefs = request.getPreferences();
            bean = model.createPrefsBean(mb, prefs.getMap());
            request.getPortletSession().setAttribute(view + PREFS_SUFFIX, (Object)bean);
        }
        try {
            Iterator it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object value = entry.getValue();
                String key = (String)entry.getKey();
                if (null == bean.get(key)) continue;
                if (value instanceof String) {
                    bean.put(key, value);
                    continue;
                }
                if (!(value instanceof String[])) continue;
                bean.put(key, ((String[])value)[0]);
            }
        }
        catch (Exception e) {
            throw new PortletException("Portlet Action error in  populating bean: ", (Throwable)e);
        }
        return bean;
    }

    protected String invokeVelocityPortletAction(String methodName, ActionRequest request, ActionResponse response, Object bean) throws PortletException {
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod(methodName, VELOCITY_PORTLET_ACTION_SIGNATURE);
            Object[] parameters = new Object[]{request, response, bean};
            String result = (String)method.invoke((Object)this, parameters);
            return result;
        }
        catch (Exception e) {
            throw new PortletException("Failed to invoke portlet action: " + methodName, (Throwable)e);
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doRender(request, response);
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doRender(request, response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doRender(request, response);
    }

    protected void doRender(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String view = this.determineLogicalView((PortletRequest)request);
        if (view == null) {
            throw new PortletException("Logical View not found: " + view);
        }
        String template = model.getTemplate(view);
        if (template == null) {
            throw new PortletException("Template not found for Logical View: " + view);
        }
        ModelBean mb = model.getModelBean(view);
        switch (mb.getBeanType()) {
            case 1: {
                this.preferencesToContext(request, view, mb);
                break;
            }
            case 0: {
                this.beanToContext(request, view, mb);
            }
        }
        this.putRequestVariable(request, "forward", new Forwarder(model, request, response));
        Map errors = (Map)request.getPortletSession().getAttribute(SESSION_ERROR_MESSAGES, 2);
        if (errors != null) {
            this.putRequestVariable(request, "ERRORS", errors);
        }
        request.setAttribute("bridges.model", (Object)model);
        PortletContext context = this.getPortletContext();
        PortletRequestDispatcher rd = context.getRequestDispatcher(template);
        rd.include(request, response);
    }

    private void beanToContext(RenderRequest request, String view, ModelBean mb) {
        Object bean;
        String key = null;
        if (mb.getLookupKey() != null) {
            key = (String)request.getAttribute(mb.getLookupKey());
        }
        if (key != null) {
            bean = model.lookupBean(mb, key);
            if (bean != null) {
                this.putBeanInSession((PortletRequest)request, mb, bean);
            }
        } else {
            bean = this.getBeanFromSession((PortletRequest)request, mb);
        }
        if (bean == null) {
            bean = model.createBean(mb);
            if (bean == null) {
                return;
            }
            this.putBeanInSession((PortletRequest)request, mb, bean);
        }
        this.putRequestVariable(request, mb.getBeanName(), bean);
    }

    private void preferencesToContext(RenderRequest request, String view, ModelBean mb) {
        Map bean = (Map)request.getPortletSession().getAttribute(view + PREFS_SUFFIX);
        if (bean == null) {
            PortletPreferences prefs = request.getPreferences();
            bean = model.createPrefsBean(mb, prefs.getMap());
            this.putBeanInSession((PortletRequest)request, mb, bean);
        }
        this.putRequestVariable(request, "prefs", bean);
    }

    private Object getBeanFromSession(PortletRequest request, ModelBean mb) {
        return request.getPortletSession().getAttribute(this.makeModelBeanKey(mb));
    }

    private void clearBeanFromSession(PortletRequest request, ModelBean mb) {
        request.getPortletSession().removeAttribute(this.makeModelBeanKey(mb));
    }

    public void startNewRecord(PortletRequest request, String view) {
        ModelBean mb = model.getModelBean(view);
        if (mb != null) {
            this.clearBeanFromSession(request, mb);
        }
    }

    private void putBeanInSession(PortletRequest request, ModelBean mb, Object bean) {
        if (bean instanceof Serializable) {
            request.getPortletSession().setAttribute(this.makeModelBeanKey(mb), bean);
        }
    }

    private String makeModelBeanKey(ModelBean mb) {
        return "ModelBean:" + mb.getBeanName();
    }

    protected void putRequestVariable(RenderRequest request, String name, Object value) {
        request.setAttribute(name, value);
    }
}

