/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.xobject;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamWrapper;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;
import org.apache.pdfbox.preflight.xobject.AbstractXObjValidator;

public class XObjFormValidator
extends AbstractXObjValidator {
    PDXObjectForm pdXObj = null;

    public XObjFormValidator(PreflightContext context, PDXObjectForm xobj) {
        super(context, xobj.getCOSStream());
        this.pdXObj = xobj;
    }

    public void validate() throws ValidationException {
        super.validate();
        this.checkGroup();
        this.checkSubtype2Value();
        this.validateXObjectResources();
        this.validateXObjectContent();
    }

    protected void checkMandatoryFields() {
        boolean pieceInfo;
        boolean lastMod = this.xobject.getItem(COSName.LAST_MODIFIED) != null;
        boolean bl = pieceInfo = this.xobject.getItem("PieceInfo") != null;
        if (lastMod ^ pieceInfo) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.7"));
            return;
        }
        COSBase bbBase = this.xobject.getItem(COSName.BBOX);
        if (bbBase == null || !COSUtils.isArray(bbBase, this.cosDocument)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.1"));
            return;
        }
    }

    protected void validateXObjectContent() throws ValidationException {
        PreflightPath vPath = this.context.getValidationPath();
        ContentStreamWrapper csWrapper = new ContentStreamWrapper(this.context, vPath.getClosestPathElement(PDPage.class));
        csWrapper.validXObjContentStream(this.pdXObj);
    }

    protected void checkGroup() {
        COSBase baseGroup = this.xobject.getItem("Group");
        COSDictionary groupDictionary = COSUtils.getAsDictionary(baseGroup, this.cosDocument);
        if (groupDictionary != null) {
            if (!"Group".equals(groupDictionary.getNameAsString(COSName.TYPE))) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.1.7", "The Group dictionary hasn't Group as Type value"));
            } else {
                String sVal = groupDictionary.getNameAsString(COSName.S);
                if (sVal == null || "Transparency".equals(sVal)) {
                    this.context.addValidationError(new ValidationResult.ValidationError("2.2.1", "Group has a transparency S entry or the S entry is null."));
                    return;
                }
            }
        }
    }

    protected void checkPS() {
        if (this.xobject.getItem(COSName.getPDFName((String)"PS")) != null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3", "Unexpected 'PS' Key"));
            return;
        }
    }

    protected void checkSubtype2Value() {
        if (this.xobject.getItem(COSName.getPDFName((String)"Subtype2")) != null && "PS".equals(this.xobject.getNameAsString("Subtype2"))) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "Unexpected 'PS' value for 'Subtype2' Key"));
            return;
        }
    }

    protected void validateXObjectResources() throws ValidationException {
        PDResources resources = this.pdXObj.getResources();
        if (resources != null) {
            ContextHelper.validateElement(this.context, resources, "resources-process");
        }
    }
}

