/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidad.util.EnumParseException;

public final class Enums {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(Enums.class);

    public static <E extends Enum> Map<String, E> createStringKeyMap(Class<E> enumClass, StringProducer<E> keyProducer) {
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        ArrayMap<String, Enum> stringKeyMap = new ArrayMap<String, Enum>(enumValues.length);
        for (Enum enumValue : enumValues) {
            stringKeyMap.put(keyProducer.toString(enumValue), enumValue);
        }
        return Collections.unmodifiableMap(stringKeyMap);
    }

    public static <T extends Enum> T stringToEnum(Map<String, T> stringToEnumMap, String key, Class<T> enumClass) {
        Enum enumValue = (Enum)stringToEnumMap.get(key);
        if (enumValue == null) {
            String message = _LOG.getMessage("ILLEGAL_ENUM_VALUE", new Object[]{enumClass.getName(), key});
            throw new IllegalArgumentException(message);
        }
        return (T)enumValue;
    }

    public static <E extends Enum> String patternOf(Class<E> enumClass, StringProducer<E> patternProducer) {
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        Iterator<Enum> iter = Arrays.asList(enumValues).iterator();
        while (iter.hasNext()) {
            Enum enumValue = iter.next();
            String enumPattern = patternProducer.toString(enumValue);
            builder.append(enumPattern);
            if (!iter.hasNext()) continue;
            builder.append("|");
        }
        builder.append(")");
        return builder.toString();
    }

    public static <E extends Enum> Collection<E> parseEnumValues(Collection<String> valuesToParse, Class<E> enumClass, EnumParser<E> enumParser, E defaultValue) throws EnumParseException {
        EnumSet<E> enumValues = EnumSet.noneOf(enumClass);
        for (String valueToParse : valuesToParse) {
            try {
                enumValues.add(enumParser.parse(valueToParse));
            }
            catch (IllegalArgumentException e) {
                throw new EnumParseException(e.getMessage(), valueToParse);
            }
        }
        if (enumValues.isEmpty() && defaultValue != null) {
            enumValues.add(defaultValue);
        }
        return enumValues;
    }

    public static <E extends Enum> Collection<E> parseEnumRequestParameter(ExternalContext external, String paramName, Class<E> enumClass, EnumParser<E> enumParser, E defaultValue) throws EnumParseException {
        Collection<String> paramValues = Enums._getRequestParamValues(external, paramName);
        return Enums.parseEnumValues(paramValues, enumClass, enumParser, defaultValue);
    }

    private static Collection<String> _getRequestParamValues(ExternalContext external, String paramName) {
        Map requestParams = external.getRequestParameterValuesMap();
        String[] paramValues = (String[])requestParams.get(paramName);
        if (paramValues == null || paramValues.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(paramValues);
    }

    public static <E extends Enum> Map<String, E> createDisplayNameMap(Class<E> enumClass) {
        return Enums.createStringKeyMap(enumClass, Enums.displayNameStringProducer(enumClass));
    }

    public static <E extends Enum> StringProducer<E> displayNameStringProducer(Class<E> enumClass) throws IllegalArgumentException {
        return Enums.methodNameStringProducer(enumClass, "displayName");
    }

    public static <E extends Enum> EnumParser<E> displayNameEnumParser(Class<E> enumClass) {
        return Enums.methodNameEnumParser(enumClass, "valueOfDisplayName");
    }

    public static <E extends Enum> StringProducer<E> methodNameStringProducer(Class<E> enumClass, String methodName) throws IllegalArgumentException {
        final Method method = Enums._getMethod(enumClass, methodName, new Class[0]);
        return new StringProducer<E>(){

            @Override
            public String toString(E enumValue) {
                return (String)Enums._invokeMethod(method, enumValue, new Object[0]);
            }
        };
    }

    public static <E extends Enum> EnumParser<E> methodNameEnumParser(final Class<E> enumClass, String methodName) throws IllegalArgumentException {
        final Method method = Enums._getMethod(enumClass, methodName, String.class);
        return new EnumParser<E>(){

            @Override
            public E parse(String value) {
                return (Enum)Enums._invokeMethod(method, enumClass, new Object[]{value});
            }
        };
    }

    private static Method _getMethod(Class<?> aClass, String methodName, Class<?> ... parameterTypes) throws IllegalArgumentException {
        try {
            return aClass.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Object _invokeMethod(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (InvocationTargetException ite) {
            Throwable targetException = ite.getTargetException();
            if (targetException instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)targetException;
            }
            throw new RuntimeException(ite);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <E extends Enum> Collection<E> parseDisplayNameEnumRequestParameter(ExternalContext external, String paramName, Class<E> enumClass, E defaultValue) throws EnumParseException {
        Collection<String> paramValues = Enums._getRequestParamValues(external, paramName);
        EnumParser<E> enumParser = Enums.displayNameEnumParser(enumClass);
        try {
            return Enums.parseEnumValues(paramValues, enumClass, enumParser, defaultValue);
        }
        catch (EnumParseException e) {
            String illegalValue = e.getIllegalValue();
            String validValues = Enums.patternOf(enumClass, Enums.displayNameStringProducer(enumClass));
            String message = _LOG.getMessage("ILLEGAL_REQUEST_PARAMETER_VALUE", new Object[]{illegalValue, paramName, validValues});
            throw new EnumParseException(message, illegalValue);
        }
    }

    public static interface EnumParser<E extends Enum> {
        public E parse(String var1) throws IllegalArgumentException;
    }

    public static interface StringProducer<E extends Enum> {
        public String toString(E var1);
    }
}

