/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.util;

import java.awt.Color;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.style.CSSStyle;
import org.apache.myfaces.trinidadinternal.style.CoreStyle;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;
import org.apache.myfaces.trinidadinternal.util.LRUCache;

public class CSSUtils {
    private static final String _PARENTHESES_BEGIN = "(";
    private static final String _NORMAL_STYLE = "normal";
    private static final String _ITALIC_STYLE = "italic";
    private static final String _OBLIQUE_STYLE = "oblique";
    private static final String _NORMAL_WEIGHT = "normal";
    private static final String _BOLD_WEIGHT = "bold";
    private static final String _BOLDER_WEIGHT = "bolder";
    private static final String _LIGHTER_WEIGHT = "lighter";
    private static final String _INVALID_COLOR = "Invalid color: ";
    private static final String _INVALID_FONT_SIZE = "Invalid font size: ";
    private static final String _INVALID_FONT_STYLE = "Invalid font style: ";
    private static final String _INVALID_FONT_WEIGHT = "Invalid font weight: ";
    private static final String _INVALID_LENGTH = "Invalid length: ";
    private static final String _INVALID_PERCENTAGE = "Invalid percentage: ";
    private static final Map<Integer, Color> _sColorCache = Collections.synchronizedMap(new LRUCache(50));
    private static final Object[] _NAMED_COLORS = new Object[]{"black", CSSUtils._getSharedColor(0), "white", CSSUtils._getSharedColor(0xFFFFFF), "gray", CSSUtils._getSharedColor(0x808080), "red", CSSUtils._getSharedColor(0xFF0000), "green", CSSUtils._getSharedColor(32768), "blue", CSSUtils._getSharedColor(255), "yellow", CSSUtils._getSharedColor(0xFFFF00), "aqua", CSSUtils._getSharedColor(65535), "fuchsia", CSSUtils._getSharedColor(0xFF00FF), "lime", CSSUtils._getSharedColor(65280), "maroon", CSSUtils._getSharedColor(0x800000), "navy", CSSUtils._getSharedColor(128), "olive", CSSUtils._getSharedColor(0x808000), "purple", CSSUtils._getSharedColor(0x800080), "silver", CSSUtils._getSharedColor(0xC0C0C0), "teal", CSSUtils._getSharedColor(32896)};
    private static final Object[] _SYSTEM_COLORS = new Object[]{"activeborder", Boolean.TRUE, "activecaption", Boolean.TRUE, "appworkspace", Boolean.TRUE, "background", Boolean.TRUE, "buttonface", Boolean.TRUE, "buttonhighlight", Boolean.TRUE, "buttonshadow", Boolean.TRUE, "buttontext", Boolean.TRUE, "captiontext", Boolean.TRUE, "graytext", Boolean.TRUE, "highlight", Boolean.TRUE, "highlighttext", Boolean.TRUE, "inactiveborder", Boolean.TRUE, "inactivecaption", Boolean.TRUE, "inactivecaptiontext", Boolean.TRUE, "infobackground", Boolean.TRUE, "infotext", Boolean.TRUE, "menu", Boolean.TRUE, "menutext", Boolean.TRUE, "scrollbar", Boolean.TRUE, "threeddarkshadow", Boolean.TRUE, "threedface", Boolean.TRUE, "threedhighlight", Boolean.TRUE, "threedlightshadow", Boolean.TRUE, "threedshadow", Boolean.TRUE, "window", Boolean.TRUE, "windowframe", Boolean.TRUE, "windowtext", Boolean.TRUE};
    private static final Object[] _NAMED_FONTS_SIZES = new Object[]{"xx-small", 8, "x-small", 9, "small", 10, "medium", 12, "large", 14, "x-large", 16, "xx-large", 18, "smaller", 10, "larger", 14};
    private static final Set<String> _URI_PROPERTIES = new HashSet<String>();
    private static final Set<String> _SPECIAL_URI_VALUES;
    private static final TrinidadLogger _LOG;

    public static String resolvePropertyValue(String styleSheetName, String baseURI, String propertyName, String propertyValue) {
        if (CSSUtils._containsURL(propertyValue)) {
            String resolvedUrl = CSSUtils._resolveURL(styleSheetName, baseURI, propertyValue);
            return resolvedUrl;
        }
        if (_URI_PROPERTIES.contains(propertyName)) {
            String specialUriValue = propertyValue;
            int parenthesesBeginIndex = specialUriValue.indexOf(_PARENTHESES_BEGIN);
            if (parenthesesBeginIndex != -1) {
                specialUriValue = propertyValue.substring(0, parenthesesBeginIndex).trim();
            }
            if (!_SPECIAL_URI_VALUES.contains(specialUriValue)) {
                _LOG.warning("URL_VALUE_EXPECTED_FOR_PROPERTY_IN_STYLE_SHEET", new Object[]{propertyName, styleSheetName, propertyValue});
            }
        }
        return propertyValue;
    }

    public static String getBaseSkinStyleSheetURI(String styleSheetName) {
        int lastSepIndex;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        assert (facesContext != null);
        ExternalContext externalContext = facesContext.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        assert (contextPath != null);
        int contextPathLength = contextPath.length();
        assert (contextPathLength > 0);
        assert (contextPath.charAt(0) == '/');
        assert (contextPath.charAt(contextPathLength - 1) != '/');
        assert (styleSheetName.length() > 0);
        assert (styleSheetName.charAt(0) != '/');
        if (styleSheetName.startsWith("META-INF/")) {
            styleSheetName = styleSheetName.substring(9);
        }
        if ((lastSepIndex = styleSheetName.lastIndexOf(47)) == -1) {
            return contextPath;
        }
        StringBuilder buffer = new StringBuilder(contextPathLength + lastSepIndex + 1);
        buffer.append(contextPath);
        buffer.append("/");
        buffer.append(styleSheetName.substring(0, lastSepIndex));
        return buffer.toString();
    }

    public static boolean isAbsoluteURI(String uriString) {
        if (uriString == null) {
            return false;
        }
        if (uriString.indexOf(58) == -1) {
            return false;
        }
        try {
            URI uri = new URI(uriString);
            return uri.isAbsolute();
        }
        catch (URISyntaxException e) {
            _LOG.warning("The URI syntax is incorrect, and can not be verified.");
            return false;
        }
    }

    public static String getAbsoluteURIValue(String styleSheetName, String baseURI, String uri) {
        String strippedURI = uri;
        String strippedBaseURI = baseURI;
        while (strippedURI.startsWith("../")) {
            int lastSepIndex = strippedBaseURI.lastIndexOf(47);
            if (lastSepIndex < 0) {
                _LOG.warning("INVALID_IMAGE_URI_IN_STYLE_SHEET", new Object[]{uri, styleSheetName});
                break;
            }
            strippedURI = strippedURI.substring(3);
            strippedBaseURI = strippedBaseURI.substring(0, lastSepIndex);
        }
        StringBuilder builder = new StringBuilder(strippedBaseURI.length() + strippedURI.length() + 2);
        builder.append(strippedBaseURI);
        builder.append("/");
        builder.append(strippedURI);
        return builder.toString();
    }

    public static CSSStyle parseStyle(String text) {
        if (text == null || "".equals(text)) {
            return null;
        }
        if (text.startsWith("{")) {
            text = text.substring(1);
        }
        if (text.endsWith("}")) {
            text = text.substring(0, text.length() - 1);
        }
        CSSStyle style = new CSSStyle();
        StringTokenizer tokens = new StringTokenizer(text, ";");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int colonPos = token.indexOf(58);
            if (colonPos < 0) continue;
            String key = token.substring(0, colonPos).trim();
            String value = token.substring(colonPos + 1).trim();
            style.setProperty(key, value);
        }
        return style;
    }

    public static Color parseColor(String value) throws PropertyParseException {
        if ((value = CSSUtils._stripWhitespace(value)) == null || value.length() == 0) {
            return null;
        }
        Color color = (Color)ArrayMap.get((Object[])_NAMED_COLORS, (Object)(value = value.toLowerCase()));
        if (color != null) {
            return color;
        }
        if (value.charAt(0) == '#') {
            int length = value.length();
            if (length == 7) {
                int rgb = 0;
                try {
                    rgb = Integer.parseInt(value.substring(1), 16);
                }
                catch (NumberFormatException e) {
                    throw new PropertyParseException(_INVALID_COLOR + value);
                }
                return CSSUtils._getSharedColor(rgb);
            }
            if (length == 4) {
                int r = 0;
                int g = 0;
                int b = 0;
                try {
                    r = Integer.parseInt(value.substring(1, 2), 16);
                    g = Integer.parseInt(value.substring(2, 3), 16);
                    b = Integer.parseInt(value.substring(3, 4), 16);
                }
                catch (NumberFormatException e) {
                    throw new PropertyParseException(_INVALID_COLOR + value);
                }
                int rgb = r << 20 & 0xF00000 | r << 16 & 0xF0000 | g << 12 & 0xF000 | g << 8 & 0xF00 | b << 4 & 0xF0 | b & 0xF;
                return CSSUtils._getSharedColor(rgb);
            }
            throw new PropertyParseException(_INVALID_COLOR + value);
        }
        if (value.startsWith("rgb")) {
            int startIndex = value.indexOf(40);
            int endIndex = value.indexOf(41);
            if (startIndex == -1 || endIndex == -1 || endIndex <= startIndex) {
                throw new PropertyParseException(_INVALID_COLOR + value);
            }
            StringTokenizer tokens = new StringTokenizer(value.substring(startIndex + 1, endIndex), " \t,");
            String redToken = null;
            String blueToken = null;
            String greenToken = null;
            try {
                redToken = tokens.nextToken();
                greenToken = tokens.nextToken();
                blueToken = tokens.nextToken();
            }
            catch (NoSuchElementException e) {
                throw new PropertyParseException(_INVALID_COLOR + value);
            }
            int red = CSSUtils._parseColorComponent(value, redToken);
            int green = CSSUtils._parseColorComponent(value, greenToken);
            int blue = CSSUtils._parseColorComponent(value, blueToken);
            return CSSUtils._getSharedColor(red, green, blue);
        }
        if (ArrayMap.get((Object[])_SYSTEM_COLORS, (Object)value) != null) {
            return null;
        }
        throw new PropertyParseException(_INVALID_COLOR + value);
    }

    public static String[] parseFontFamilies(String value) throws PropertyParseException {
        if (value == null || value.length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(value, ",\"");
        while (tokens.hasMoreTokens()) {
            String family = CSSUtils._stripWhitespace(tokens.nextToken());
            if (family == null || family.length() <= 0) continue;
            v.addElement(family);
        }
        Object[] families = new String[v.size()];
        v.copyInto(families);
        return families;
    }

    public static Integer parseFontSize(String value) throws PropertyParseException {
        if ((value = CSSUtils._stripWhitespace(value)) == null || value.length() == 0) {
            return null;
        }
        Integer fontSize = (Integer)ArrayMap.get((Object[])_NAMED_FONTS_SIZES, (Object)(value = value.toLowerCase()));
        if (fontSize != null) {
            return fontSize;
        }
        if (CSSUtils._isLength(value)) {
            return CSSUtils.parseLength(value);
        }
        if (CSSUtils._isPercentage(value)) {
            return CSSUtils._parsePercentage(value);
        }
        throw new PropertyParseException(_INVALID_FONT_SIZE + value);
    }

    public static Object parseFontStyle(String value) throws PropertyParseException {
        if ((value = CSSUtils._stripWhitespace(value)) == null || value.length() == 0) {
            return null;
        }
        if ("normal".equals(value = value.toLowerCase())) {
            return CoreStyle.PLAIN_FONT_STYLE;
        }
        if (_ITALIC_STYLE.equals(value) || _OBLIQUE_STYLE.equals(value)) {
            return CoreStyle.ITALIC_FONT_STYLE;
        }
        throw new PropertyParseException(_INVALID_FONT_STYLE + value);
    }

    public static Object parseFontWeight(String value) throws PropertyParseException {
        if ((value = CSSUtils._stripWhitespace(value)) == null || value.length() == 0) {
            return null;
        }
        if ("normal".equals(value = value.toLowerCase()) || _LIGHTER_WEIGHT.equals(value)) {
            return CoreStyle.PLAIN_FONT_WEIGHT;
        }
        if (_BOLD_WEIGHT.equals(value) || _BOLDER_WEIGHT.equals(value)) {
            return CoreStyle.BOLD_FONT_WEIGHT;
        }
        try {
            int weight = Integer.parseInt(value);
            if (weight >= 100 && weight <= 900 && weight % 100 == 0) {
                if (weight >= 600) {
                    return CoreStyle.BOLD_FONT_WEIGHT;
                }
                return CoreStyle.PLAIN_FONT_WEIGHT;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new PropertyParseException(_INVALID_FONT_WEIGHT + value);
    }

    public static Integer parseLength(String value) throws PropertyParseException {
        if (CSSUtils._isLength(value = CSSUtils._stripWhitespace(value))) {
            return CSSUtils._parseLength(value);
        }
        throw new PropertyParseException(_INVALID_LENGTH + value);
    }

    public static String getColorValue(Color color) {
        StringBuffer buffer = new StringBuffer(7);
        buffer.append('#');
        buffer.append(CSSUtils._getHexColorComponent(color.getRed()));
        buffer.append(CSSUtils._getHexColorComponent(color.getGreen()));
        buffer.append(CSSUtils._getHexColorComponent(color.getBlue()));
        return buffer.toString();
    }

    private static String _getHexColorComponent(int colorComponent) {
        String hex = Integer.toString(colorComponent, 16);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    private static int _parseColorComponent(String value, String comp) throws PropertyParseException {
        if (comp == null || comp.length() == 0) {
            return 0;
        }
        int col = 0;
        if (comp.endsWith("%")) {
            double percent = 0.0;
            try {
                percent = Double.parseDouble(comp.substring(0, comp.length() - 1));
            }
            catch (NumberFormatException e) {
                throw new PropertyParseException(_INVALID_COLOR + value);
            }
            col = (int)(percent / 100.0 * 255.0);
        } else {
            try {
                col = Integer.parseInt(comp);
            }
            catch (NumberFormatException e) {
                throw new PropertyParseException(_INVALID_COLOR + value);
            }
        }
        if (col < 0) {
            return 0;
        }
        return col > 255 ? 255 : col;
    }

    private static boolean _isLength(String value) {
        assert (value != null);
        return value.endsWith("in") || value.endsWith("cm") || value.endsWith("mm") || value.endsWith("pt") || value.endsWith("pc") || value.endsWith("em") || value.endsWith("ex") || value.endsWith("px");
    }

    private static boolean _isPercentage(String value) {
        assert (value != null);
        return value.endsWith("%");
    }

    private static Integer _parseLength(String value) throws PropertyParseException {
        assert (CSSUtils._isLength(value));
        double size = 0.0;
        try {
            size = Double.parseDouble(value.substring(0, value.length() - 2));
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException(_INVALID_LENGTH + value);
        }
        int points = 0;
        if (value.endsWith("in")) {
            points = (int)(72.0 * size);
        } else if (value.endsWith("cm")) {
            points = (int)(72.0 * size / 2.54);
        } else if (value.endsWith("mm")) {
            points = (int)(72.0 * size / 25.4);
        } else if (value.endsWith("pt")) {
            points = (int)size;
        } else if (value.endsWith("pc")) {
            points = (int)(12.0 * size);
        } else if (value.endsWith("em")) {
            points = (int)(12.0 * size);
        } else if (value.endsWith("ex")) {
            points = (int)(6.0 * size);
        } else if (value.endsWith("px")) {
            points = (int)size;
        } else {
            throw new PropertyParseException(_INVALID_LENGTH + value);
        }
        return points;
    }

    private static Integer _parsePercentage(String value) throws PropertyParseException {
        assert (CSSUtils._isPercentage(value));
        double percent = 0.0;
        try {
            percent = Double.parseDouble(value.substring(0, value.length() - 1));
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException(_INVALID_PERCENTAGE + value);
        }
        return (int)(percent / 100.0 * 12.0);
    }

    private static Color _getSharedColor(int rgb) {
        Color sharedColor = _sColorCache.get(rgb);
        if (sharedColor == null) {
            sharedColor = new Color(rgb);
            _sColorCache.put(rgb, sharedColor);
        }
        return sharedColor;
    }

    private static Color _getSharedColor(int r, int g, int b) {
        return CSSUtils._getSharedColor(r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF);
    }

    private static String _stripWhitespace(String str) {
        int endIndex;
        int startIndex;
        if (str == null) {
            return null;
        }
        int length = str.length();
        for (startIndex = 0; startIndex < length && Character.isWhitespace(str.charAt(startIndex)); ++startIndex) {
        }
        for (endIndex = length; endIndex > 0 && Character.isWhitespace(str.charAt(endIndex - 1)); --endIndex) {
        }
        if (startIndex == 0 && endIndex == length) {
            return str;
        }
        if (endIndex <= startIndex) {
            return null;
        }
        return str.substring(startIndex, endIndex);
    }

    private static String _resolveURL(String styleSheetName, String baseURI, String url) {
        int endIndex = -1;
        int index = url.indexOf("url(");
        StringBuilder builder = new StringBuilder();
        while (index >= 0) {
            builder.append(url, endIndex + 1, index);
            endIndex = url.indexOf(41, index + 3);
            String uri = url.substring(index + 4, endIndex);
            int uriLength = uri.length();
            if (uriLength > 0 && (uri.charAt(0) == '\'' && uri.charAt(uriLength - 1) == '\'' || uri.charAt(0) == '\"' && uri.charAt(uriLength - 1) == '\"')) {
                uri = uri.substring(1, uriLength - 1);
                uriLength -= 2;
            }
            if (uriLength == 0) {
                _LOG.warning("EMPTY_URL_IN_STYLE_SHEET", (Object)styleSheetName);
            }
            builder.append("url(");
            String resolvedURI = CSSUtils._resolveCSSURI(styleSheetName, baseURI, uri);
            builder.append(resolvedURI);
            builder.append(')');
            index = url.indexOf("url(", endIndex);
        }
        builder.append(url, endIndex + 1, url.length());
        return builder.toString();
    }

    private static String _resolveCSSURI(String styleSheetName, String baseURI, String uri) {
        String resolvedURI = uri;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        assert (facesContext != null);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (uri.charAt(0) == '/') {
            int uriLength = uri.length();
            if (uriLength > 1 && uri.charAt(1) == '/') {
                resolvedURI = uri.substring(1, uriLength);
            } else {
                String contextPath = externalContext.getRequestContextPath();
                assert (contextPath.charAt(0) == '/');
                assert (contextPath.charAt(contextPath.length() - 1) != '/');
                StringBuilder builder = new StringBuilder(contextPath.length() + uri.length());
                builder.append(contextPath);
                builder.append(uri);
                resolvedURI = builder.toString();
            }
        } else if (CSSUtils._isRelativeURI(uri)) {
            resolvedURI = CSSUtils.getAbsoluteURIValue(styleSheetName, baseURI, uri);
        }
        return externalContext.encodeResourceURL(resolvedURI);
    }

    private static boolean _isRelativeURI(String uri) {
        return uri.charAt(0) != '/' && uri.indexOf(58) < 0;
    }

    private static boolean _containsURL(String value) {
        if (value == null) {
            return false;
        }
        return value.indexOf("url(") >= 0;
    }

    static {
        _URI_PROPERTIES.add("background-image");
        _URI_PROPERTIES.add("cue-after");
        _URI_PROPERTIES.add("cue-before");
        _URI_PROPERTIES.add("list-style-image");
        _SPECIAL_URI_VALUES = new HashSet<String>();
        _SPECIAL_URI_VALUES.add("none");
        _SPECIAL_URI_VALUES.add("inherit");
        _SPECIAL_URI_VALUES.add("-moz-linear-gradient");
        _SPECIAL_URI_VALUES.add("-webkit-linear-gradient");
        _SPECIAL_URI_VALUES.add("radial-gradient");
        _SPECIAL_URI_VALUES.add("linear-gradient");
        _SPECIAL_URI_VALUES.add("repeating-linear-gradient");
        _SPECIAL_URI_VALUES.add("repeating-radial-gradient");
        _LOG = TrinidadLogger.createTrinidadLogger(CSSUtils.class);
    }
}

