/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent.parse;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.parse.VersionId;

class NameVersion {
    private Object[] _entries;
    private static final char _WILD_CHAR = '*';
    private static final String _WILD_CHAR_STRING = String.valueOf('*');
    private static final double NAME_EXACT_MATCH = 1000.0;
    private static final double NAME_STAR_MATCH = 999.0;
    private static final double VERSION_EXACT_MATCH = 10.0;
    private static final double VERSION_GE_MATCH = 1.0;
    private static final double VERSION_STAR_MATCH = 9.0;
    public static final double NO_MATCH = 0.0;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(NameVersion.class);

    NameVersion(String value) throws ParseException {
        this._entries = this._parseEntries(value);
    }

    public double match(String name, VersionId version) {
        if (this._entries == null) {
            return 0.0;
        }
        if (name == null) {
            return 0.0;
        }
        double score = 0.0;
        for (int i = 0; i < this._entries.length; ++i) {
            double score1;
            Object[] entry = (Object[])this._entries[i];
            if (entry[0] == null || !((score1 = this._matchName((NameEntry)entry[0], name)) > 0.0)) continue;
            if (entry[1] == null & score1 >= score) {
                score = score1;
                continue;
            }
            double score2 = this._matchVersion((VersionEntry)entry[1], version);
            if (!(score2 > 0.0) || !(score1 + score2 >= score)) continue;
            score = score1 + score2;
        }
        return score;
    }

    private Object[] _parseEntries(String value) throws ParseException {
        NameEntry curr;
        if (value == null) {
            return null;
        }
        int length = value.length();
        char[] data = new char[length + 1];
        value.getChars(0, length, data, 0);
        data[length] = '\u0000';
        boolean inQuote = false;
        int start = 0;
        int i = 0;
        char ch = data[i];
        ArrayList<Object[]> entries = new ArrayList<Object[]>(5);
        VersionEntry vEntry = null;
        NameEntry head = curr = new NameEntry();
        curr.next = curr;
        block7: while (i < length + 1) {
            Object[] obj;
            NameEntry temp;
            switch (ch) {
                case '\'': {
                    if (!inQuote) {
                        inQuote = true;
                    } else {
                        inQuote = false;
                        if (start != i) {
                            throw new ParseException(_LOG.getMessage("UNEXPECTED_BACKSLASH"), i);
                        }
                    }
                    ch = data[++i];
                    continue block7;
                }
                case '\\': {
                    ch = data[++i];
                    if (ch != '.' || ch != '\\') {
                        throw new ParseException(_LOG.getMessage("EXPECTED_PERIOD_OR_BACKSLASH"), i);
                    }
                    ch = data[++i];
                    continue block7;
                }
                case '.': {
                    if (start != i) {
                        curr.next.text = new String(data, start, i - start);
                        curr = curr.next;
                        curr.next = new NameEntry();
                    }
                    if ((ch = data[++i]) != '*') {
                        throw new ParseException(_LOG.getMessage("EXPECTED_ASTERISK"), i);
                    }
                    curr.next.text = _WILD_CHAR_STRING;
                    curr = curr.next;
                    curr.next = new NameEntry();
                    ch = data[++i];
                    start = i;
                    continue block7;
                }
                case '/': {
                    if (start != i) {
                        curr.next.text = new String(data, start, i - start);
                        curr = curr.next;
                        curr.next = new NameEntry();
                    }
                    ch = data[++i];
                    start = i;
                    if (inQuote) {
                        while (ch != '\'' && ch != '\u0000') {
                            ch = data[++i];
                        }
                    } else {
                        while (!Character.isWhitespace(ch) && ch != '\u0000') {
                            ch = data[++i];
                        }
                    }
                    if (i - start <= 0) {
                        throw new ParseException(_LOG.getMessage("EXPECTING_CHAR"), i);
                    }
                    vEntry = this._parseVersion(new String(data, start, i - start), i);
                    start = i;
                    continue block7;
                }
                case '\u0000': {
                    if (inQuote) {
                        throw new ParseException(_LOG.getMessage("UNTERMINATED_QUOTE"), i);
                    }
                    if (start != i) {
                        curr.next.text = new String(data, start, i - start);
                        curr = curr.next;
                        curr.next = new NameEntry();
                    }
                    if (head.text != null) {
                        temp = curr.next;
                        curr.next = null;
                        obj = new Object[]{head, vEntry};
                        curr.next = curr = (head = temp);
                        entries.add(obj);
                        vEntry = null;
                    }
                    ++i;
                    continue block7;
                }
            }
            if (!inQuote && Character.isWhitespace(ch)) {
                if (start != i) {
                    curr.next.text = new String(data, start, i - start);
                    curr = curr.next;
                    curr.next = new NameEntry();
                }
                if (head.text != null) {
                    temp = curr.next;
                    curr.next = null;
                    obj = new Object[]{head, vEntry};
                    curr.next = curr = (head = temp);
                    entries.add(obj);
                    vEntry = null;
                }
                ch = data[++i];
                while (Character.isWhitespace(ch)) {
                    ch = data[++i];
                }
                start = i;
            }
            ch = data[++i];
        }
        return entries.toArray(new Object[entries.size()]);
    }

    private VersionEntry _parseVersion(String value, int offset) throws ParseException {
        int length = value.length();
        char[] data = new char[length + 1];
        int i = 0;
        value.getChars(0, length, data, 0);
        data[length] = '\u0000';
        char ch = data[i];
        VersionEntry vEntry = new VersionEntry();
        block4: while (i < length + 1) {
            switch (ch) {
                case '\u0000': {
                    String version = value.substring(0, i);
                    if (version.length() == 0) {
                        return null;
                    }
                    vEntry._versionId = new VersionId(version);
                    vEntry._type = 0;
                    ++i;
                    continue block4;
                }
                case '*': 
                case '+': {
                    String version = value.substring(0, i);
                    ++i;
                    while (i < length) {
                        if (!Character.isWhitespace(ch)) {
                            throw new ParseException(_LOG.getMessage("UNEXPECTED_CHAR"), offset + i);
                        }
                        ++i;
                    }
                    if (version.length() == 0) {
                        return null;
                    }
                    vEntry._versionId = new VersionId(version);
                    vEntry._type = ch == '*' ? 2 : 1;
                    ++i;
                    continue block4;
                }
            }
            ch = data[++i];
        }
        return vEntry;
    }

    private double _matchName(NameEntry entry, String matchValue) {
        if (matchValue == null) {
            return 0.0;
        }
        int strLen = matchValue.length();
        int len = 0;
        if (entry.text != _WILD_CHAR_STRING) {
            if (matchValue.indexOf(entry.text, len) == 0) {
                len = entry.text.length();
                entry = entry.next;
                if (entry == null) {
                    return 1000.0;
                }
            } else {
                return 0.0;
            }
        }
        while (entry.next != null) {
            if (entry.text != _WILD_CHAR_STRING) {
                int index = matchValue.indexOf(entry.text, len);
                if (index == -1) {
                    return 0.0;
                }
                len = index + entry.text.length();
            }
            entry = entry.next;
        }
        if (entry.text != _WILD_CHAR_STRING && !matchValue.endsWith(entry.text)) {
            return 0.0;
        }
        return 999.0 * ((double)len / (double)strLen);
    }

    private double _matchVersion(VersionEntry entry, VersionId version) {
        if (version == null) {
            return 0.0;
        }
        if (entry._type == 2) {
            Iterator<String> vIterator1 = version.iterator();
            Iterator<String> vIterator2 = entry._versionId.iterator();
            int matchedParts = 0;
            while (vIterator1.hasNext() && vIterator2.hasNext()) {
                String part2;
                String part1 = vIterator1.next();
                if (!part1.equals(part2 = vIterator2.next())) {
                    return 0.0;
                }
                ++matchedParts;
            }
            while (vIterator2.hasNext()) {
                if ("0".equals(vIterator2.next())) continue;
                return 0.0;
            }
            int totNoOfParts = matchedParts;
            while (vIterator1.hasNext()) {
                ++totNoOfParts;
                vIterator1.next();
            }
            return 9.0 * (double)matchedParts / (double)totNoOfParts;
        }
        if (entry._type == 1) {
            Iterator<String> vIterator1 = version.iterator();
            Iterator<String> vIterator2 = entry._versionId.iterator();
            while (vIterator1.hasNext() && vIterator2.hasNext()) {
                try {
                    int v1 = Integer.parseInt(vIterator1.next());
                    int v2 = Integer.parseInt(vIterator2.next());
                    if (v1 > v2) {
                        return 1.0 * (entry._versionId.getVersion() / version.getVersion());
                    }
                    if (v1 >= v2) continue;
                    return 0.0;
                }
                catch (NumberFormatException npe) {
                    return 0.0;
                }
            }
            while (vIterator2.hasNext()) {
                try {
                    if (Integer.parseInt(vIterator2.next()) == 0) continue;
                    return 0.0;
                }
                catch (NumberFormatException npe) {
                    return 0.0;
                }
            }
            return 1.0 * (entry._versionId.getVersion() / version.getVersion());
        }
        Iterator<String> vIterator1 = version.iterator();
        Iterator<String> vIterator2 = entry._versionId.iterator();
        while (vIterator1.hasNext() && vIterator2.hasNext()) {
            String part2;
            String part1 = vIterator1.next();
            if (part1.equals(part2 = vIterator2.next())) continue;
            return 0.0;
        }
        while (vIterator1.hasNext()) {
            if ("0".equals(vIterator1.next())) continue;
            return 0.0;
        }
        while (vIterator2.hasNext()) {
            if ("0".equals(vIterator2.next())) continue;
            return 0.0;
        }
        return 10.0;
    }

    private static class VersionEntry {
        static final int EXACT_TYPE = 0;
        static final int PLUS_TYPE = 1;
        static final int STAR_TYPE = 2;
        int _type;
        VersionId _versionId;

        private VersionEntry() {
        }
    }

    private static class NameEntry {
        String text;
        NameEntry next;

        private NameEntry() {
        }
    }
}

