/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.schedule.AbstractCompactScheduleRenderer;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.UIScheduleBase;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;

public class ScheduleCompactMonthRenderer
extends AbstractCompactScheduleRenderer
implements Serializable {
    private static final long serialVersionUID = 2926607881214603314L;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        int dayOfWeek;
        ScheduleDay day;
        Iterator dayIterator;
        if (!component.isRendered()) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)("schedule-compact-" + schedule.getTheme()), null);
        writer.writeAttribute("style", (Object)"border-style: none; overflow: hidden;", null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "month"), null);
        writer.writeAttribute("style", (Object)"width: 100%;", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        Calendar cal = this.getCalendarInstance(schedule, schedule.getModel().getSelectedDate());
        String dayOfWeekDateFormat = schedule.getCompactMonthDayOfWeekDateFormat();
        if (dayOfWeekDateFormat != null && dayOfWeekDateFormat.length() > 0) {
            DateFormat dayOfWeekFormater = ScheduleCompactMonthRenderer.getDateFormat(context, schedule, dayOfWeekDateFormat);
            writer.startElement("thead", (UIComponent)schedule);
            writer.startElement("tr", (UIComponent)schedule);
            dayIterator = schedule.getModel().iterator();
            while (dayIterator.hasNext()) {
                day = (ScheduleDay)dayIterator.next();
                cal.setTime(day.getDate());
                dayOfWeek = cal.get(7);
                writer.startElement("th", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "header"), null);
                if (schedule.isSplitWeekend() && dayOfWeek == 7) {
                    writer.endElement("th");
                    break;
                }
                writer.writeText((Object)dayOfWeekFormater.format(day.getDate()), null);
                writer.endElement("th");
                if (dayOfWeek != 1) continue;
                break;
            }
            writer.endElement("tr");
            writer.endElement("thead");
        }
        writer.startElement("tbody", (UIComponent)schedule);
        int selectedMonth = cal.get(2);
        dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            day = (ScheduleDay)dayIterator.next();
            cal.setTime(day.getDate());
            dayOfWeek = cal.get(7);
            int dayOfMonth = cal.get(5);
            int currentMonth = cal.get(2);
            boolean isWeekend = dayOfWeek == 7 || dayOfWeek == 1;
            cal.setTime(day.getDate());
            this.writeDayCell(context, writer, schedule, day, dayOfWeek, dayOfMonth, isWeekend, currentMonth == selectedMonth, !isWeekend && schedule.isSplitWeekend() ? 2 : 1);
        }
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected int getDefaultRowHeight() {
        return 120;
    }

    protected void writeDayCell(FacesContext context, ResponseWriter writer, HtmlSchedule schedule, ScheduleDay day, int dayOfWeek, int dayOfMonth, boolean isWeekend, boolean isCurrentMonth, int rowspan) throws IOException {
        if (dayOfWeek == 2 || schedule.isSplitWeekend() && dayOfWeek == 1) {
            writer.startElement("tr", (UIComponent)schedule);
        }
        super.writeDayCell(context, writer, schedule, day, 100.0f / (float)(schedule.isSplitWeekend() ? 6 : 7), dayOfWeek, dayOfMonth, isWeekend, isCurrentMonth, rowspan);
        if (schedule.isSplitWeekend() && dayOfWeek == 7 || dayOfWeek == 1) {
            writer.endElement("tr");
        }
    }

    protected int getRowHeight(UIScheduleBase schedule) {
        if (schedule != null) {
            int height = schedule.getCompactMonthRowHeight();
            return height == 0 ? this.getDefaultRowHeight() : height;
        }
        return this.getDefaultRowHeight();
    }
}

