/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.application;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import javax.faces.context.FacesContext;
import javax.portlet.RenderResponse;
import javax.portlet.faces.BridgeWriteBehindResponse;
import javax.portlet.filter.RenderResponseWrapper;

public class BridgeViewHandlerRenderResponseWrapper
extends RenderResponseWrapper
implements BridgeWriteBehindResponse {
    private DirectByteArrayServletOutputStream mByteStream;
    private CharArrayWriter mCharWriter;
    private PrintWriter mPrintWriter;
    private int mStatus = 200;
    private boolean mHasWriteBehindMarkup = false;

    public BridgeViewHandlerRenderResponseWrapper() {
        super((RenderResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse());
    }

    public BridgeViewHandlerRenderResponseWrapper(RenderResponse wrapped) {
        super(wrapped);
    }

    public void flushBuffer() {
        if (this.isChars()) {
            this.mPrintWriter.flush();
        }
    }

    public int getBufferSize() {
        if (this.isBytes()) {
            return this.mByteStream.size();
        }
        if (this.isChars()) {
            return this.mCharWriter.size();
        }
        return 0;
    }

    public void reset() {
        super.reset();
        if (this.isBytes()) {
            this.mByteStream.reset();
        } else if (this.isChars()) {
            this.mPrintWriter.flush();
            this.mCharWriter.reset();
        }
    }

    public void resetBuffer() {
        super.resetBuffer();
        if (this.isBytes()) {
            this.mByteStream.reset();
        } else if (this.isChars()) {
            this.mPrintWriter.flush();
            this.mCharWriter.reset();
        }
    }

    public OutputStream getPortletOutputStream() throws IOException {
        if (this.mPrintWriter != null) {
            throw new IllegalStateException();
        }
        if (this.mByteStream == null) {
            this.mByteStream = new DirectByteArrayServletOutputStream();
        }
        return this.mByteStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.mByteStream != null) {
            throw new IllegalStateException();
        }
        if (this.mPrintWriter == null) {
            this.mCharWriter = new CharArrayWriter(4096);
            this.mPrintWriter = new PrintWriter(this.mCharWriter);
        }
        return this.mPrintWriter;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public boolean isBytes() {
        return this.mByteStream != null;
    }

    public boolean isChars() {
        return this.mCharWriter != null;
    }

    public byte[] getBytes() {
        if (this.isBytes()) {
            return this.mByteStream.toByteArray();
        }
        return null;
    }

    public char[] getChars() {
        if (this.isChars()) {
            this.mCharWriter.flush();
            return this.mCharWriter.toCharArray();
        }
        return null;
    }

    public String toString() {
        if (this.isChars()) {
            this.mCharWriter.flush();
            return this.mCharWriter.toString();
        }
        if (this.isBytes()) {
            return this.mByteStream.toString();
        }
        return null;
    }

    public void clearWrappedResponse() throws IOException {
        this.resetBuffers();
    }

    public void flushMarkupToWrappedResponse() throws IOException {
        RenderResponse response = this.getResponse();
        this.flushBuffer();
        if (this.isBytes()) {
            response.getPortletOutputStream().write(this.getBytes());
            this.mByteStream.reset();
        } else if (this.isChars()) {
            response.getWriter().write(this.getChars());
            this.mCharWriter.reset();
        }
    }

    public void flushContentToWrappedResponse() throws IOException {
        this.mHasWriteBehindMarkup = true;
        this.flushMarkupToWrappedResponse();
    }

    public void flushToWrappedResponse() throws IOException {
        this.mHasWriteBehindMarkup = true;
        this.flushMarkupToWrappedResponse();
    }

    public void flushToWriter(Writer writer, String encoding) throws IOException {
        this.flushBuffer();
        if (this.isBytes()) {
            throw new IOException("Invalid flushToWriter as the code is writing bytes to an OutputStream.");
        }
        if (this.isChars()) {
            writer.write(this.getChars());
            this.mCharWriter.reset();
        }
    }

    public void resetBuffers() throws IOException {
        if (this.isBytes()) {
            this.mByteStream.reset();
        } else if (this.isChars()) {
            this.mPrintWriter.flush();
            this.mCharWriter.reset();
        }
    }

    public boolean hasFacesWriteBehindMarkup() {
        return this.mHasWriteBehindMarkup;
    }

    private class DirectByteArrayOutputStream
    extends ByteArrayOutputStream {
        public DirectByteArrayOutputStream(int initialCapacity) {
            super(initialCapacity);
        }

        public ByteBuffer getByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }
    }

    private class DirectByteArrayServletOutputStream
    extends OutputStream {
        private DirectByteArrayOutputStream mByteArrayOutputStream;

        public DirectByteArrayServletOutputStream() {
            this.mByteArrayOutputStream = new DirectByteArrayOutputStream(4096);
        }

        public void write(int n) {
            this.mByteArrayOutputStream.write(n);
        }

        public byte[] toByteArray() {
            return this.mByteArrayOutputStream.toByteArray();
        }

        public int size() {
            return this.mByteArrayOutputStream.size();
        }

        public void reset() {
            this.mByteArrayOutputStream.reset();
        }
    }
}

