/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.validation.ConstraintViolation;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import org.apache.myfaces.extensions.validator.beanval.ExtValBeanValidationContext;
import org.apache.myfaces.extensions.validator.beanval.util.BeanValidationUtils;
import org.apache.myfaces.extensions.validator.beanval.validation.strategy.BeanValidationVirtualValidationStrategy;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.metadata.extractor.MetaDataExtractor;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.MetaDataTransformer;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
class BeanValidationModuleValidationInterceptorInternals {
    private Logger logger;

    BeanValidationModuleValidationInterceptorInternals(Logger logger) {
        this.logger = logger;
    }

    PropertyDetails extractPropertyDetails(FacesContext facesContext, UIComponent uiComponent, Map<String, Object> propertiesForExtraction) {
        PropertyDetails result = (PropertyDetails)this.getComponentMetaDataExtractor(propertiesForExtraction).extract(facesContext, (Object)uiComponent).getInformation("property_details", PropertyDetails.class);
        if (result.getBaseObject() == null) {
            this.logger.warning("no base object at " + result.getKey() + " component-id: " + uiComponent.getClientId(facesContext));
        }
        return result.getBaseObject() != null ? result : null;
    }

    MetaDataExtractor getComponentMetaDataExtractor(Map<String, Object> properties) {
        return ExtValUtils.getComponentMetaDataExtractorWith(properties);
    }

    void initComponentWithPropertyDetails(FacesContext facesContext, UIComponent uiComponent, PropertyDetails propertyDetails) {
        Class[] foundGroups = this.resolveGroups(facesContext, uiComponent);
        if (foundGroups == null) {
            return;
        }
        if (foundGroups.length == 0) {
            foundGroups = new Class[]{Default.class};
        }
        Class targetClass = propertyDetails.getBaseObject().getClass();
        ElementDescriptor elementDescriptor = BeanValidationUtils.getElementDescriptor(targetClass = ProxyUtils.getUnproxiedClass(targetClass), propertyDetails.getProperty());
        if (elementDescriptor == null) {
            return;
        }
        this.processElementDescriptor(facesContext, uiComponent, foundGroups, elementDescriptor);
    }

    void processElementDescriptor(FacesContext facesContext, UIComponent uiComponent, Class[] foundGroups, ElementDescriptor elementDescriptor) {
        for (ConstraintDescriptor constraintDescriptor : elementDescriptor.findConstraints().unorderedAndMatchingGroups(foundGroups).getConstraintDescriptors()) {
            Map<String, Object> metaData = this.transformConstraintDescriptorToMetaData(constraintDescriptor, elementDescriptor.getElementClass());
            if (metaData == null || metaData.isEmpty()) continue;
            ExtValUtils.configureComponentWithMetaData((FacesContext)facesContext, (UIComponent)uiComponent, metaData);
        }
    }

    @ToDo(value=Priority.MEDIUM, description="ConstraintDescriptor#isReportAsSingleViolation")
    private Map<String, Object> transformConstraintDescriptorToMetaData(ConstraintDescriptor<?> constraintDescriptor, Class elementClass) {
        Set composingConstraints;
        HashMap<String, Object> result = new HashMap<String, Object>();
        MetaDataTransformer metaDataTransformer = ExtValUtils.getMetaDataTransformerForValidationStrategy((ValidationStrategy)new BeanValidationVirtualValidationStrategy(constraintDescriptor, elementClass));
        if (metaDataTransformer != null) {
            result.putAll(this.transformMetaData(metaDataTransformer, constraintDescriptor));
        }
        if (!constraintDescriptor.isReportAsSingleViolation() && (composingConstraints = constraintDescriptor.getComposingConstraints()) != null && !composingConstraints.isEmpty()) {
            result.putAll(this.transformComposingConstraints(composingConstraints, elementClass));
        }
        return result;
    }

    private Map<String, Object> transformComposingConstraints(Set<ConstraintDescriptor<?>> composingConstraints, Class elementClass) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ConstraintDescriptor<?> constraintDescriptor : composingConstraints) {
            result.putAll(this.transformConstraintDescriptorToMetaData(constraintDescriptor, elementClass));
        }
        return result;
    }

    private Map<String, Object> transformMetaData(MetaDataTransformer metaDataTransformer, ConstraintDescriptor<?> constraintDescriptor) {
        this.logger.fine(metaDataTransformer.getClass().getName() + " instantiated");
        MetaDataEntry entry = new MetaDataEntry();
        entry.setKey(constraintDescriptor.getAnnotation().annotationType().getName());
        entry.setValue(constraintDescriptor);
        Map result = metaDataTransformer.convertMetaData(entry);
        return result;
    }

    boolean hasBeanValidationConstraints(PropertyInformation propertyInformation) {
        PropertyDetails propertyDetails = ExtValUtils.getPropertyDetails((PropertyInformation)propertyInformation);
        Class targetClass = ProxyUtils.getUnproxiedClass(propertyDetails.getBaseObject().getClass());
        return BeanValidationUtils.getElementDescriptor(targetClass, propertyDetails.getProperty()) != null;
    }

    Set<ConstraintViolation<Object>> validate(FacesContext facesContext, UIComponent uiComponent, Object convertedObject, PropertyInformation propertyInformation, boolean cascadedValidation) {
        Class baseBeanClass = this.getBaseClassType(propertyInformation);
        String propertyName = this.getPropertyToValidate(propertyInformation);
        Class[] groups = this.resolveGroups(facesContext, uiComponent);
        if (groups == null) {
            return null;
        }
        return BeanValidationUtils.validate(baseBeanClass, propertyName, convertedObject, groups, cascadedValidation);
    }

    Class getBaseClassType(PropertyInformation propertyInformation) {
        Class<?> result = ExtValUtils.getPropertyDetails((PropertyInformation)propertyInformation).getBaseObject().getClass();
        return ProxyUtils.getUnproxiedClass(result);
    }

    String getPropertyToValidate(PropertyInformation propertyInformation) {
        return ExtValUtils.getPropertyDetails((PropertyInformation)propertyInformation).getProperty();
    }

    Class[] resolveGroups(FacesContext facesContext, UIComponent uiComponent) {
        return ExtValBeanValidationContext.getCurrentInstance().getGroups(facesContext.getViewRoot().getViewId(), uiComponent.getClientId(facesContext));
    }
}

