/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultPropertyInformation
implements PropertyInformation {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, Object> informationMap = new HashMap<String, Object>();
    private List<MetaDataEntry> metaDataList = new ArrayList<MetaDataEntry>();

    @Override
    public boolean containsInformation(String key) {
        return this.informationMap.containsKey(key);
    }

    @Override
    public Object getInformation(String key) {
        return this.informationMap.get(key);
    }

    @Override
    public <T> T getInformation(String key, Class<T> targetClass) {
        return (T)this.getInformation(key);
    }

    @Override
    public void setInformation(String key, Object value) {
        this.logger.finest("new information added key: " + key + " value: " + value);
        this.informationMap.put(key, value);
    }

    @Override
    public MetaDataEntry[] getMetaDataEntries() {
        return this.metaDataList.toArray(new MetaDataEntry[this.metaDataList.size()]);
    }

    @Override
    public void addMetaDataEntry(MetaDataEntry metaDataEntry) {
        metaDataEntry.setProperties(this.informationMap);
        this.metaDataList.add(metaDataEntry);
    }

    @Override
    public void resetMetaDataEntries() {
        this.logger.finest("resetting meta-data entries");
        this.metaDataList.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPropertyInformation)) {
            return false;
        }
        DefaultPropertyInformation that = (DefaultPropertyInformation)o;
        if (!((Object)this.informationMap).equals(that.informationMap)) {
            return false;
        }
        return ((Object)this.metaDataList).equals(that.metaDataList);
    }

    public int hashCode() {
        int result = this.createNullAwareHashCode(this.informationMap);
        result = 31 * result + this.createNullAwareHashCode(this.metaDataList);
        return result;
    }

    private int createNullAwareHashCode(Object o) {
        try {
            return o.hashCode();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }
}

