/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.storage;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.storage.PropertyStorage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultPropertyStorage
implements PropertyStorage {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, Map<String, Field>> fieldMap = new ConcurrentHashMap<String, Map<String, Field>>();
    private Map<String, Map<String, Method>> methodMap = new ConcurrentHashMap<String, Map<String, Method>>();
    private Map<String, List<String>> fieldNotAvailableMap = new ConcurrentHashMap<String, List<String>>();
    private Map<String, List<String>> methodNotAvailableMap = new ConcurrentHashMap<String, List<String>>();

    @Override
    public void storeField(Class targetClass, String property, Field field) {
        if (field != null) {
            this.getFieldMapForClass(targetClass).put(property, field);
        } else {
            this.getNotAvailableFieldListForClass(targetClass).add(property);
        }
    }

    @Override
    public void storeMethod(Class targetClass, String property, Method method) {
        if (method != null) {
            this.getMethodMapForClass(targetClass).put(property, method);
        } else {
            this.getNotAvailableMethodListForClass(targetClass).add(property);
        }
    }

    @Override
    public Field getField(Class targetClass, String property) {
        Map<String, Field> fieldMap = this.getFieldMapForClass(targetClass);
        return fieldMap.get(property);
    }

    @Override
    public Method getMethod(Class targetClass, String property) {
        Map<String, Method> methodMap = this.getMethodMapForClass(targetClass);
        return methodMap.get(property);
    }

    @Override
    public boolean containsField(Class targetClass, String property) {
        boolean result = this.getFieldMapForClass(targetClass).containsKey(property);
        if (!result) {
            result = this.getNotAvailableFieldListForClass(targetClass).contains(property);
        }
        return result;
    }

    @Override
    public boolean containsMethod(Class targetClass, String property) {
        boolean result = this.getMethodMapForClass(targetClass).containsKey(property);
        if (!result) {
            result = this.getNotAvailableMethodListForClass(targetClass).contains(property);
        }
        return result;
    }

    private Map<String, Field> getFieldMapForClass(Class target) {
        String key = ProxyUtils.getClassName(target);
        if (!this.fieldMap.containsKey(key)) {
            this.fieldMap.put(key, new ConcurrentHashMap());
        }
        return this.fieldMap.get(key);
    }

    private List<String> getNotAvailableFieldListForClass(Class target) {
        String key = ProxyUtils.getClassName(target);
        if (!this.fieldNotAvailableMap.containsKey(key)) {
            this.fieldNotAvailableMap.put(key, new CopyOnWriteArrayList());
        }
        return this.fieldNotAvailableMap.get(key);
    }

    private Map<String, Method> getMethodMapForClass(Class target) {
        String key = ProxyUtils.getClassName(target);
        if (!this.methodMap.containsKey(key)) {
            this.methodMap.put(key, new ConcurrentHashMap());
        }
        return this.methodMap.get(key);
    }

    private List<String> getNotAvailableMethodListForClass(Class target) {
        String key = ProxyUtils.getClassName(target);
        if (!this.methodNotAvailableMap.containsKey(key)) {
            this.methodNotAvailableMap.put(key, new CopyOnWriteArrayList());
        }
        return this.methodNotAvailableMap.get(key);
    }
}

