/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.el;

import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@ToDo(value=Priority.MEDIUM, description="difference between [ and [' - test with more constellations")
@UsageInformation(value={UsageCategory.API})
public class ValueBindingExpression {
    private ValueBindingExpression base;
    private String value;
    private String prefix;
    private String token;
    private static final ELHelper EL_HELPER = ExtValUtils.getELHelper();

    public static ValueBindingExpression replaceOrAddProperty(ValueBindingExpression valueBindingExpression, String newProperty) {
        if (valueBindingExpression.getBaseExpression() != null) {
            return ValueBindingExpression.replaceProperty(valueBindingExpression, newProperty);
        }
        return ValueBindingExpression.addProperty(valueBindingExpression, newProperty);
    }

    public static ValueBindingExpression replaceProperty(ValueBindingExpression valueBindingExpression, String newProperty) {
        if (valueBindingExpression.getProperty().endsWith("']")) {
            valueBindingExpression = valueBindingExpression.getBaseExpression();
        }
        if (valueBindingExpression.getBaseExpression() != null) {
            return ValueBindingExpression.addProperty(valueBindingExpression.getBaseExpression(), newProperty);
        }
        return ValueBindingExpression.addProperty(valueBindingExpression, newProperty);
    }

    public static ValueBindingExpression addProperty(ValueBindingExpression valueBindingExpression, String newProperty) {
        String sourceExpression = valueBindingExpression.getExpressionString();
        String result = sourceExpression.substring(0, sourceExpression.length() - 1);
        if (newProperty.startsWith("['")) {
            return new ValueBindingExpression(result + newProperty + "}");
        }
        return new ValueBindingExpression(result + "." + newProperty + "}");
    }

    public ValueBindingExpression(String expression) {
        int index2;
        if (!EL_HELPER.isELTermWellFormed(expression)) {
            throw new IllegalStateException(expression + " is no valid el-expression");
        }
        boolean isDynamicBaseAndProperty = expression.lastIndexOf("']") == -1;
        int index1 = isDynamicBaseAndProperty ? expression.lastIndexOf("]") : expression.lastIndexOf("']");
        if (index1 > (index2 = expression.lastIndexOf("."))) {
            expression = expression.substring(0, index1);
            int index3 = this.findIndexOfStartingBracket(expression);
            this.value = isDynamicBaseAndProperty ? expression.substring(index3 + 1, index1) : expression.substring(index3 + 2, index1);
            this.base = new ValueBindingExpression(expression.substring(0, index3) + "}");
            this.token = isDynamicBaseAndProperty ? "[" : "['";
        } else if (index2 > index1) {
            this.value = expression.substring(index2 + 1, expression.length() - 1);
            this.base = new ValueBindingExpression(expression.substring(0, index2) + "}");
            this.token = ".";
        } else {
            this.value = expression.substring(2, expression.length() - 1);
            this.prefix = expression.substring(0, 1);
        }
    }

    public String getProperty() {
        this.value = this.value.trim();
        if ("[".equals(this.token) && this.value.startsWith("'")) {
            return this.value.substring(1, this.value.length() - 1);
        }
        return this.value;
    }

    public ValueBindingExpression getBaseExpression() {
        return this.base;
    }

    public String getExpressionString() {
        if (this.base != null) {
            String baseExpression = this.base.getExpressionString();
            if ("['".equals(this.token)) {
                return baseExpression.substring(0, baseExpression.length() - 1) + this.token + this.value + "']}";
            }
            if ("[".equals(this.token)) {
                return baseExpression.substring(0, baseExpression.length() - 1) + this.token + this.value + "]}";
            }
            return baseExpression.substring(0, baseExpression.length() - 1) + this.token + this.value + "}";
        }
        return this.prefix + "{" + this.value + "}";
    }

    public String getPrefix() {
        if (this.base != null) {
            return this.base.getPrefix();
        }
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (this.base != null) {
            this.base.setPrefix(prefix);
        } else {
            this.prefix = prefix;
        }
    }

    public String toString() {
        return this.getExpressionString();
    }

    public int hashCode() {
        return this.getExpressionString().hashCode();
    }

    public boolean equals(Object target) {
        return target instanceof ValueBindingExpression && this.getExpressionString().equals(((ValueBindingExpression)target).getExpressionString());
    }

    private int findIndexOfStartingBracket(String expression) {
        int closeCount = 0;
        for (int i = expression.length() - 1; i > 0; --i) {
            if (expression.charAt(i) == '[') {
                if (--closeCount >= 0) continue;
                return i;
            }
            if (expression.charAt(i) != ']') continue;
            ++closeCount;
        }
        return 0;
    }
}

