/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf2.impl.listener.request;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.enterprise.context.ContextNotActiveException;
import javax.faces.FacesException;
import javax.faces.application.ViewExpiredException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import org.apache.myfaces.extensions.cdi.core.api.config.view.DefaultErrorView;
import org.apache.myfaces.extensions.cdi.core.api.navigation.ViewNavigationHandler;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.impl.projectstage.ProjectStageProducer;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;

class DefaultErrorViewExceptionHandler
extends ExceptionHandlerWrapper {
    private ExceptionHandler wrapped;
    private boolean advancedQualifierRequiredForDependencyInjection;
    private ViewNavigationHandler viewNavigationHandler;

    protected DefaultErrorViewExceptionHandler() {
    }

    DefaultErrorViewExceptionHandler(ExceptionHandler wrapped, boolean advancedQualifierRequiredForDependencyInjection) {
        this.wrapped = wrapped;
        this.advancedQualifierRequiredForDependencyInjection = advancedQualifierRequiredForDependencyInjection;
    }

    public void handle() throws FacesException {
        this.lazyInit();
        Iterator exceptionQueuedEventIterator = this.getUnhandledExceptionQueuedEvents().iterator();
        while (exceptionQueuedEventIterator.hasNext()) {
            UIViewRoot uiViewRoot;
            FacesContext facesContext;
            ExceptionQueuedEventContext exceptionQueuedEventContext = (ExceptionQueuedEventContext)((ExceptionQueuedEvent)exceptionQueuedEventIterator.next()).getSource();
            Throwable throwable = exceptionQueuedEventContext.getException();
            String viewId = null;
            if (throwable instanceof ViewExpiredException) {
                viewId = ((ViewExpiredException)throwable).getViewId();
            } else if (throwable instanceof ContextNotActiveException) {
                facesContext = exceptionQueuedEventContext.getContext();
                Flash flash = facesContext.getExternalContext().getFlash();
                if (flash.containsKey((Object)ContextNotActiveException.class.getName())) break;
                if (facesContext.getViewRoot() != null) {
                    viewId = facesContext.getViewRoot().getViewId();
                }
            }
            if (viewId == null || (uiViewRoot = (facesContext = exceptionQueuedEventContext.getContext()).getApplication().getViewHandler().createView(facesContext, viewId)) == null) continue;
            if (facesContext.isProjectStage(javax.faces.application.ProjectStage.Development) || ProjectStageProducer.getInstance().getProjectStage() == ProjectStage.Development) {
                throwable.printStackTrace();
            }
            facesContext.setViewRoot(uiViewRoot);
            exceptionQueuedEventIterator.remove();
            Flash flash = facesContext.getExternalContext().getFlash();
            flash.put((Object)throwable.getClass().getName(), (Object)throwable);
            flash.keep(throwable.getClass().getName());
            this.viewNavigationHandler.navigateTo(DefaultErrorView.class);
            break;
        }
        this.wrapped.handle();
    }

    private void lazyInit() {
        if (this.viewNavigationHandler == null) {
            this.tryToInjectFields(this.wrapped);
            this.viewNavigationHandler = (ViewNavigationHandler)CodiUtils.getContextualReferenceByClass(ViewNavigationHandler.class, (Annotation[])new Annotation[0]);
        }
    }

    private void tryToInjectFields(ExceptionHandler exceptionHandler) {
        CodiUtils.injectFields((Object)exceptionHandler, (boolean)this.advancedQualifierRequiredForDependencyInjection);
        if (exceptionHandler instanceof ExceptionHandlerWrapper) {
            this.tryToInjectFields(((ExceptionHandlerWrapper)exceptionHandler).getWrapped());
        }
    }

    public ExceptionHandler getWrapped() {
        this.lazyInit();
        return this.wrapped;
    }
}

