/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.Conversation;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.ConversationSubGroup;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowContext;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.ConversationConfig;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.event.CloseWindowContextEvent;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.DefaultConversation;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.DefaultConversationKey;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.TimeoutExpirationEvaluator;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.ConversationFactory;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.ConversationKey;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableConversation;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ExceptionUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.JsfUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.RequestCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
class JsfWindowContext
implements EditableWindowContext {
    private static final long serialVersionUID = 5272798129165017829L;
    private final String id;
    private final WindowContextConfig windowContextConfig;
    private final ConversationConfig conversationConfig;
    private final boolean projectStageDevelopment;
    private BeanManager beanManager;
    private ConcurrentHashMap<ConversationKey, EditableConversation> groupedConversations = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap();
    private final TimeoutExpirationEvaluator expirationEvaluator;

    JsfWindowContext(String windowContextId, WindowContextConfig windowContextConfig, ConversationConfig conversationConfig, boolean projectStageDevelopment, BeanManager beanManager) {
        this.id = windowContextId;
        this.windowContextConfig = windowContextConfig;
        this.conversationConfig = conversationConfig;
        this.projectStageDevelopment = projectStageDevelopment;
        this.beanManager = beanManager;
        this.expirationEvaluator = new TimeoutExpirationEvaluator(this.windowContextConfig.getWindowContextTimeoutInMinutes());
    }

    public String getId() {
        return this.id;
    }

    public void closeConversations() {
        this.closeConversations(false);
    }

    public void close() {
        if (this.windowContextConfig.isCloseWindowContextEventEnabled()) {
            this.beanManager.fireEvent((Object)new CloseWindowContextEvent((WindowContext)this), new Annotation[0]);
        }
        this.closeConversations(true);
        this.attributes.clear();
    }

    private synchronized void closeConversations(boolean forceEnd) {
        for (Map.Entry<ConversationKey, EditableConversation> conversationEntry : this.groupedConversations.entrySet()) {
            this.closeAndRemoveConversation(conversationEntry.getKey(), conversationEntry.getValue(), null, forceEnd);
        }
        JsfUtils.resetConversationCache();
    }

    @Override
    public EditableConversation getConversation(Class<?> conversationGroupKey, Annotation ... qualifiers) {
        Class<? extends Annotation> scopeType;
        DefaultConversationKey conversationKey;
        EditableConversation conversation;
        ConversationSubGroup conversationSubGroup = conversationGroupKey.getAnnotation(ConversationSubGroup.class);
        Class[] subGroups = null;
        if (conversationSubGroup != null) {
            subGroups = conversationSubGroup.subGroup();
            conversationGroupKey = ConversationUtils.convertToSubGroup(conversationGroupKey);
        }
        if ((conversation = RequestCache.getConversation(conversationKey = new DefaultConversationKey(scopeType = ConversationUtils.convertToScope(this.beanManager, conversationGroupKey, qualifiers), conversationGroupKey, qualifiers))) == null) {
            conversation = this.getConversationForKey(conversationKey, false);
            if (conversation != null && !conversation.isActive()) {
                this.closeAndRemoveConversation(conversationKey, conversation, subGroups, true);
                conversation = null;
            }
            if (conversation == null) {
                conversation = this.createConversation(conversationGroupKey, qualifiers);
                this.groupedConversations.put(conversationKey, conversation);
            }
            RequestCache.setConversation(conversationKey, conversation);
        }
        return conversation;
    }

    public boolean isConversationActive(Class conversationGroupKey, Annotation ... qualifiers) {
        Class<? extends Annotation> scopeType = ConversationUtils.convertToScope(this.beanManager, conversationGroupKey, qualifiers);
        DefaultConversationKey conversationKey = new DefaultConversationKey(scopeType, conversationGroupKey, qualifiers);
        EditableConversation conversation = RequestCache.getConversation(conversationKey);
        if (conversation == null && (conversation = this.getConversationForKey(conversationKey, false)) == null) {
            return false;
        }
        return conversation.getActiveState();
    }

    public Conversation closeConversation(Class<?> conversationGroupKey, Annotation ... qualifiers) {
        ConversationSubGroup conversationSubGroup = conversationGroupKey.getAnnotation(ConversationSubGroup.class);
        Class[] subGroups = null;
        if (conversationSubGroup != null) {
            subGroups = conversationSubGroup.subGroup();
            conversationGroupKey = ConversationUtils.convertToSubGroup(conversationGroupKey);
        }
        Class<? extends Annotation> scopeType = ConversationUtils.convertToScope(this.beanManager, conversationGroupKey, qualifiers);
        DefaultConversationKey conversationKey = new DefaultConversationKey(scopeType, conversationGroupKey, qualifiers);
        EditableConversation conversation = this.getConversationForKey(conversationKey, true);
        return this.closeAndRemoveConversation(conversationKey, conversation, subGroups, true);
    }

    public Set<Conversation> closeConversationGroup(Class<?> conversationGroupKey) {
        ConversationSubGroup conversationSubGroup = conversationGroupKey.getAnnotation(ConversationSubGroup.class);
        Class[] subGroups = null;
        if (conversationSubGroup != null) {
            subGroups = conversationSubGroup.subGroup();
            conversationGroupKey = ConversationUtils.convertToSubGroup(conversationGroupKey);
        }
        HashSet<Conversation> removedConversations = new HashSet<Conversation>();
        for (Map.Entry<ConversationKey, EditableConversation> conversationEntry : this.groupedConversations.entrySet()) {
            if (!conversationGroupKey.isAssignableFrom(conversationEntry.getKey().getConversationGroup())) continue;
            removedConversations.add(this.closeAndRemoveConversation(conversationEntry.getKey(), conversationEntry.getValue(), subGroups, true));
        }
        return removedConversations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableConversation closeAndRemoveConversation(ConversationKey conversationKey, EditableConversation conversation, Class<?>[] subGroups, boolean forceEnd) {
        this.logInformationAboutConversations("before JsfWindowContext#endAndRemoveConversation");
        try {
            if (subGroups != null) {
                EditableConversation editableConversation = this.closeSubGroups(conversationKey, subGroups);
                return editableConversation;
            }
            if (forceEnd) {
                conversation.close();
                EditableConversation editableConversation = this.groupedConversations.remove(conversationKey);
                return editableConversation;
            }
            conversation.deactivate();
            if (!conversation.isActive()) {
                EditableConversation editableConversation = this.groupedConversations.remove(conversationKey);
                return editableConversation;
            }
        }
        finally {
            this.logInformationAboutConversations("after JsfWindowContext#endAndRemoveConversation");
        }
        return null;
    }

    private EditableConversation closeSubGroups(ConversationKey conversationKey, Class<?>[] subGroups) {
        EditableConversation editableConversation = this.groupedConversations.get(conversationKey);
        if (editableConversation == null) {
            throw new IllegalStateException(conversationKey.toString() + " is no valid key for an existing conversation");
        }
        ArrayList implicitSubGroupCandidates = new ArrayList();
        for (Class<?> subGroup : subGroups) {
            if (editableConversation.removeBeanEntry(subGroup) != null) continue;
            implicitSubGroupCandidates.add(subGroup);
        }
        this.tryToCloseImplicitConversationSubGroup(editableConversation, implicitSubGroupCandidates);
        return editableConversation;
    }

    private void tryToCloseImplicitConversationSubGroup(EditableConversation editableConversation, List<Class<?>> subGroupTypes) {
        if (!subGroupTypes.isEmpty()) {
            for (Class<?> subGroupType : subGroupTypes) {
                Set<Class<?>> concreteBeanClasses = editableConversation.getBeanSubGroup(subGroupType);
                for (Class<?> beanClass : concreteBeanClasses) {
                    editableConversation.removeBeanEntry(beanClass);
                }
            }
        }
    }

    @Override
    public EditableConversation createConversation(Class<?> conversationGroupKey, Annotation ... qualifiers) {
        Class<? extends Annotation> scopeType = ConversationUtils.convertToScope(this.beanManager, conversationGroupKey, qualifiers);
        DefaultConversationKey conversationKey = new DefaultConversationKey(scopeType, conversationGroupKey, qualifiers);
        ConversationFactory conversationFactory = (ConversationFactory)CodiUtils.getContextualReferenceByClass(ConversationFactory.class, (Annotation[])new Annotation[0]);
        return conversationFactory.createConversation(conversationKey, this.conversationConfig);
    }

    @Override
    public Map<ConversationKey, EditableConversation> getConversations() {
        return Collections.unmodifiableMap(this.groupedConversations);
    }

    public WindowContextConfig getConfig() {
        return this.windowContextConfig;
    }

    @Override
    public boolean isActive() {
        return !this.expirationEvaluator.isExpired();
    }

    @Override
    public Date getLastAccess() {
        return this.expirationEvaluator.getLastAccess();
    }

    @Override
    public void touch() {
        this.expirationEvaluator.touch();
    }

    @Override
    public void removeInactiveConversations() {
        Iterator<EditableConversation> conversations = this.groupedConversations.values().iterator();
        while (conversations.hasNext()) {
            EditableConversation conversation = conversations.next();
            if (conversation.getActiveState()) continue;
            conversations.remove();
        }
    }

    public boolean setAttribute(String name, Object value) {
        return this.setAttribute(name, value, true);
    }

    public boolean setAttribute(String name, Object value, boolean forceOverride) {
        if (value == null || !forceOverride && this.containsAttribute(name)) {
            return false;
        }
        this.attributes.put(name, value);
        return true;
    }

    public boolean containsAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public <T> T getAttribute(String name, Class<T> targetType) {
        return (T)this.attributes.get(name);
    }

    private EditableConversation getConversationForKey(ConversationKey conversationKey, boolean forceNewConversation) {
        EditableConversation editableConversation = this.groupedConversations.get(conversationKey);
        if (editableConversation != null) {
            return editableConversation;
        }
        if (!forceNewConversation) {
            return null;
        }
        if (conversationKey.getQualifiers() != null) {
            editableConversation = this.getConversationForDynamicKey(conversationKey);
        }
        if (editableConversation != null) {
            return editableConversation;
        }
        throw ExceptionUtils.conversationNotFoundException(conversationKey.toString());
    }

    private EditableConversation getConversationForDynamicKey(ConversationKey conversationKey) {
        for (Map.Entry<ConversationKey, EditableConversation> conversationEntry : this.groupedConversations.entrySet()) {
            if (!this.isSameConversationType(conversationEntry.getKey(), conversationKey) || !this.compareAnnotations(conversationEntry.getKey().getQualifiers(), conversationKey.getQualifiers())) continue;
            return conversationEntry.getValue();
        }
        return null;
    }

    private boolean isSameConversationType(ConversationKey currentConversationKey, ConversationKey conversationKey) {
        return currentConversationKey.getConversationGroup().equals(conversationKey.getConversationGroup()) && currentConversationKey.getScope().equals(conversationKey.getScope());
    }

    private boolean compareAnnotations(Set<Annotation> source, Set<Annotation> target) {
        HashSet<Annotation> sourceAnnotations = new HashSet<Annotation>(source);
        HashSet<Annotation> targetAnnotations = new HashSet<Annotation>(target);
        Iterator sourceAnnotationIterator = sourceAnnotations.iterator();
        block0: while (sourceAnnotationIterator.hasNext()) {
            Annotation sourceAnnotation = (Annotation)sourceAnnotationIterator.next();
            Iterator targetAnnotationIterator = targetAnnotations.iterator();
            while (targetAnnotationIterator.hasNext()) {
                Annotation targetAnnotation = (Annotation)targetAnnotationIterator.next();
                if (!CodiUtils.isQualifierEqual((Annotation)sourceAnnotation, (Annotation)targetAnnotation)) continue;
                sourceAnnotationIterator.remove();
                targetAnnotationIterator.remove();
                continue block0;
            }
        }
        return sourceAnnotations.isEmpty() && targetAnnotations.isEmpty();
    }

    private void logInformationAboutConversations(String label) {
        if (!this.projectStageDevelopment) {
            return;
        }
        Logger logger = Logger.getLogger(JsfWindowContext.class.getName());
        logger.info(label);
        logger.info("\n*** conversations - start ***");
        for (Map.Entry<ConversationKey, EditableConversation> conversationEntry : this.groupedConversations.entrySet()) {
            if (!(conversationEntry.getValue() instanceof DefaultConversation)) continue;
            logger.info(conversationEntry.getValue().toString());
        }
        logger.info("\n\n*** conversations - end ***");
        logger.info("***************************");
    }
}

