/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.context;

import jakarta.faces.context.ResponseWriter;
import jakarta.faces.context.ResponseWriterWrapper;
import java.io.IOException;
import java.util.Map;

public class PartialResponseWriter
extends ResponseWriterWrapper {
    public static final String RENDER_ALL_MARKER = "jakarta.faces.ViewRoot";
    public static final String VIEW_STATE_MARKER = "jakarta.faces.ViewState";
    private boolean hasChanges;
    private String insertType;

    public PartialResponseWriter(ResponseWriter writer) {
        super(writer);
    }

    public void delete(String targetId) throws IOException {
        this.startChanges();
        this.startElement("delete", null);
        this.writeAttribute("id", targetId, null);
        this.endElement("delete");
    }

    @Override
    public void endDocument() throws IOException {
        if (this.hasChanges) {
            this.endInsert();
            this.endElement("changes");
            this.hasChanges = false;
        }
        this.endElement("partial-response");
    }

    public void endError() throws IOException {
        this.endCDATA();
        this.endElement("error-message");
        this.endElement("error");
    }

    public void endEval() throws IOException {
        this.endCDATA();
        this.endElement("eval");
    }

    public void endExtension() throws IOException {
        this.endElement("extension");
    }

    public void endInsert() throws IOException {
        if (this.insertType == null) {
            return;
        }
        this.endCDATA();
        this.endElement(this.insertType);
        this.endElement("insert");
        this.insertType = null;
    }

    public void endUpdate() throws IOException {
        this.endCDATA();
        this.endElement("update");
    }

    public void redirect(String url) throws IOException {
        this.startElement("redirect", null);
        this.writeAttribute("url", url, null);
        this.endElement("redirect");
    }

    @Override
    public void startDocument() throws IOException {
        this.startElement("partial-response", null);
        this.hasChanges = false;
        this.insertType = null;
    }

    public void startError(String errorName) throws IOException {
        this.startElement("error", null);
        this.startElement("error-name", null);
        this.write(errorName);
        this.endElement("error-name");
        this.startElement("error-message", null);
        this.startCDATA();
    }

    public void startEval() throws IOException {
        this.startChanges();
        this.startElement("eval", null);
        this.startCDATA();
    }

    public void startExtension(Map<String, String> attributes) throws IOException {
        this.startChanges();
        this.startElement("extension", null);
        for (String attrName : attributes.keySet()) {
            this.writeAttribute(attrName, attributes.get(attrName), null);
        }
    }

    public void startInsertAfter(String targetId) throws IOException {
        this.startInsertCommon("after", targetId);
    }

    public void startInsertBefore(String targetId) throws IOException {
        this.startInsertCommon("before", targetId);
    }

    public void startUpdate(String targetId) throws IOException {
        this.startChanges();
        this.startElement("update", null);
        this.writeAttribute("id", targetId, null);
        this.startCDATA();
    }

    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.startChanges();
        this.startElement("attributes", null);
        this.writeAttribute("id", targetId, null);
        for (String attrName : attributes.keySet()) {
            this.startElement("attribute", null);
            this.writeAttribute("name", attrName, null);
            this.writeAttribute("value", attributes.get(attrName), null);
            this.endElement("attribute");
        }
        this.endElement("attributes");
    }

    private void startChanges() throws IOException {
        if (!this.hasChanges) {
            this.startElement("changes", null);
            this.hasChanges = true;
        }
    }

    private void startInsertCommon(String type, String targetId) throws IOException {
        if (this.insertType != null) {
            return;
        }
        this.insertType = type;
        this.startChanges();
        this.startElement("insert", null);
        this.startElement(this.insertType, null);
        this.writeAttribute("id", targetId, null);
        this.startCDATA();
    }
}

