/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Producer;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.flow.FlowUtils;
import org.apache.myfaces.flow.cdi.FlowBuilderExtension;
import org.apache.myfaces.flow.cdi.FlowScopeBeanHolder;
import org.apache.myfaces.flow.cdi.FlowScopeMap;
import org.apache.myfaces.spi.FacesFlowProvider;

public class DefaultCDIFacesFlowProvider
extends FacesFlowProvider {
    private static final String CURRENT_FLOW_SCOPE_MAP = "oam.flow.SCOPE_MAP";
    private static final char SEPARATOR_CHAR = '.';
    private BeanManager _beanManager;
    private boolean _initialized;
    private List<Flow> flows;

    private boolean isFlowScopeBeanHolderCreated(FacesContext facesContext) {
        if (facesContext.getExternalContext().getSession(false) == null) {
            return false;
        }
        return facesContext.getExternalContext().getSessionMap().containsKey(FlowScopeBeanHolder.CREATED);
    }

    @Override
    public void onSessionDestroyed() {
        FlowScopeBeanHolder flowScopeBeanHolder;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && this.isFlowScopeBeanHolderCreated(facesContext) && (flowScopeBeanHolder = CDIUtils.get(this._beanManager, FlowScopeBeanHolder.class, false, new Annotation[0])) != null) {
            flowScopeBeanHolder.destroyBeans();
        }
    }

    @Override
    public Iterator<Flow> getAnnotatedFlows(FacesContext facesContext) {
        BeanManager beanManager = this.getBeanManager(facesContext);
        if (beanManager == null) {
            Logger.getLogger(DefaultCDIFacesFlowProvider.class.getName()).log(Level.INFO, "CDI BeanManager not found");
            return null;
        }
        if (this.flows == null) {
            this.flows = new ArrayList<Flow>();
            FlowBuilderExtension extension = CDIUtils.get(beanManager, FlowBuilderExtension.class);
            for (Producer<Flow> producer : extension.getFlowProducers()) {
                Flow flow = (Flow)producer.produce(beanManager.createCreationalContext(null));
                this.flows.add(flow);
            }
        }
        return this.flows.iterator();
    }

    @Override
    public void doAfterEnterFlow(FacesContext context, Flow flow) {
        BeanManager beanManager = this.getBeanManager(context);
        if (beanManager != null) {
            FlowScopeBeanHolder beanHolder = CDIUtils.get(beanManager, FlowScopeBeanHolder.class);
            beanHolder.createCurrentFlowScope(context);
        }
        String mapKey = this.getFlowKey(flow);
        context.getAttributes().remove(mapKey);
    }

    @Override
    public void doBeforeExitFlow(FacesContext context, Flow flow) {
        BeanManager beanManager = this.getBeanManager(context);
        if (beanManager != null) {
            FlowScopeBeanHolder beanHolder = CDIUtils.get(beanManager, FlowScopeBeanHolder.class);
            beanHolder.destroyCurrentFlowScope(context);
        }
        String mapKey = this.getFlowKey(flow);
        context.getAttributes().remove(mapKey);
    }

    @Override
    public Map<Object, Object> getCurrentFlowScope(FacesContext facesContext) {
        Flow flow = facesContext.getApplication().getFlowHandler().getCurrentFlow(facesContext);
        if (flow != null) {
            String mapKey = this.getFlowKey(flow);
            return (Map)facesContext.getAttributes().computeIfAbsent(mapKey, k -> new FlowScopeMap(this.getBeanManager(facesContext), FlowUtils.getFlowMapKey(facesContext, flow)));
        }
        return null;
    }

    @Override
    public void refreshClientWindow(FacesContext facesContext) {
        BeanManager beanManager;
        Flow flow;
        if (!facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext) && (flow = facesContext.getApplication().getFlowHandler().getCurrentFlow(facesContext)) != null && (beanManager = this.getBeanManager(facesContext)) != null) {
            FlowScopeBeanHolder beanHolder = CDIUtils.get(beanManager, FlowScopeBeanHolder.class);
            beanHolder.refreshClientWindow(facesContext);
        }
    }

    public BeanManager getBeanManager(FacesContext facesContext) {
        if (this._beanManager == null && !this._initialized) {
            this._beanManager = CDIUtils.getBeanManager(facesContext.getExternalContext());
            this._initialized = true;
        }
        return this._beanManager;
    }

    protected String getFlowKey(Flow flow) {
        return "oam.flow.SCOPE_MAP." + flow.getDefiningDocumentId() + '.' + flow.getId();
    }
}

