/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.apache.vysper.xml.fragment.Renderer;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.DiscussionMessage;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Occupant;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.History;
import org.apache.vysper.xmpp.stanza.Stanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscussionHistory {
    public static final int DEFAULT_HISTORY_SIZE = 20;
    private int maxItems = 20;
    private DiscussionMessage subjectMessage;
    private List<DiscussionMessage> items = new ArrayList<DiscussionMessage>();

    public void append(Stanza stanza, Occupant sender) {
        this.append(stanza, sender, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Stanza stanza, Occupant sender, Calendar timestamp) {
        List<DiscussionMessage> list = this.items;
        synchronized (list) {
            DiscussionMessage discMsg = new DiscussionMessage(stanza, sender, timestamp);
            if (discMsg.hasSubject() && !discMsg.hasBody()) {
                this.subjectMessage = discMsg;
            } else {
                this.items.add(discMsg);
            }
            if (this.getSize() > this.maxItems) {
                this.items.remove(0);
            }
        }
    }

    private int getSize() {
        int size = this.items.size();
        if (this.subjectMessage != null) {
            ++size;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Stanza> createStanzas(Occupant receiver, boolean includeJid, History history) {
        List<DiscussionMessage> list = this.items;
        synchronized (list) {
            int maxstanzas = history != null && history.getMaxStanzas() != null ? history.getMaxStanzas() : -1;
            int maxchars = history != null && history.getMaxChars() != null ? history.getMaxChars() : -1;
            int seconds = history != null && history.getSeconds() != null ? history.getSeconds() : -1;
            ArrayList<Stanza> stanzas = new ArrayList<Stanza>();
            if (maxchars != 0 && maxstanzas != 0 && seconds != 0) {
                int counter = 0;
                int totalChars = 0;
                ArrayList<DiscussionMessage> itemsWithSubject = new ArrayList<DiscussionMessage>(this.items);
                if (this.subjectMessage != null) {
                    itemsWithSubject.add(this.subjectMessage);
                }
                long secondsLimit = -1L;
                if (seconds != -1) {
                    Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    cal.add(13, -seconds);
                    secondsLimit = cal.getTimeInMillis();
                }
                for (int i = itemsWithSubject.size() - 1; i > -1; --i) {
                    DiscussionMessage item = (DiscussionMessage)itemsWithSubject.get(i);
                    Stanza stanza = item.createStanza(receiver, includeJid);
                    ++counter;
                    if (secondsLimit != -1L && secondsLimit > item.getTimestamp().getTimeInMillis() || history != null && history.getSince() != null && history.getSince().after(item.getTimestamp()) || maxchars != -1 && (totalChars += new Renderer((XMLElement)stanza).getComplete().length()) > maxchars) break;
                    stanzas.add(stanza);
                    if (maxstanzas != -1 && counter == maxstanzas) break;
                }
            }
            Collections.reverse(stanzas);
            return stanzas;
        }
    }
}

