/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.websockets;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.vysper.mina.TCPEndpoint;
import org.apache.vysper.storage.StorageProviderRegistry;
import org.apache.vysper.storage.inmemory.MemoryStorageProviderRegistry;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AccountCreationException;
import org.apache.vysper.xmpp.authorization.AccountManagement;
import org.apache.vysper.xmpp.extension.websockets.WebSocketEndpoint;
import org.apache.vysper.xmpp.modules.Module;
import org.apache.vysper.xmpp.modules.extension.xep0049_privatedata.PrivateDataModule;
import org.apache.vysper.xmpp.modules.extension.xep0054_vcardtemp.VcardTempModule;
import org.apache.vysper.xmpp.modules.extension.xep0092_software_version.SoftwareVersionModule;
import org.apache.vysper.xmpp.modules.extension.xep0119_xmppping.XmppPingModule;
import org.apache.vysper.xmpp.modules.extension.xep0202_entity_time.EntityTimeModule;
import org.apache.vysper.xmpp.server.Endpoint;
import org.apache.vysper.xmpp.server.XMPPServer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class DemoServer {
    public static void main(String[] args) throws AccountCreationException, EntityFormatException, FileNotFoundException {
        EntityImpl user3;
        EntityImpl user2;
        EntityImpl user1;
        MemoryStorageProviderRegistry providerRegistry = new MemoryStorageProviderRegistry();
        AccountManagement accountManagement = (AccountManagement)providerRegistry.retrieve(AccountManagement.class);
        if (!accountManagement.verifyAccountExists((Entity)(user1 = EntityImpl.parse((String)"user1@vysper.org")))) {
            accountManagement.addUser((Entity)user1, "password1");
        }
        if (!accountManagement.verifyAccountExists((Entity)(user2 = EntityImpl.parse((String)"user2@vysper.org")))) {
            accountManagement.addUser((Entity)user2, "password1");
        }
        if (!accountManagement.verifyAccountExists((Entity)(user3 = EntityImpl.parse((String)"user3@vysper.org")))) {
            accountManagement.addUser((Entity)user3, "password1");
        }
        XMPPServer server = new XMPPServer("vysper.org");
        server.addEndpoint((Endpoint)new TCPEndpoint());
        WebSocketEndpoint wsEndpoint = new WebSocketEndpoint(){

            protected Server createJettyServer() {
                Server jetty = super.createJettyServer();
                ResourceHandler resourceHandler = new ResourceHandler();
                resourceHandler.setResourceBase("src/examples/client");
                jetty.setHandler((Handler)resourceHandler);
                HandlerCollection handlers = new HandlerCollection();
                handlers.addHandler((Handler)resourceHandler);
                jetty.setHandler((Handler)handlers);
                return jetty;
            }
        };
        wsEndpoint.setContextPath("/ws");
        server.addEndpoint((Endpoint)wsEndpoint);
        server.setStorageProviderRegistry((StorageProviderRegistry)providerRegistry);
        server.setTLSCertificateInfo(new File("src/test/resources/bogus_mina_tls.cert"), "boguspw");
        try {
            server.start();
            System.out.println("vysper server is running...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        server.addModule((Module)new SoftwareVersionModule());
        server.addModule((Module)new EntityTimeModule());
        server.addModule((Module)new VcardTempModule());
        server.addModule((Module)new XmppPingModule());
        server.addModule((Module)new PrivateDataModule());
    }
}

