/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.util.LittleEndian;

public class PicturesTable {
    static final int TYPE_IMAGE = 8;
    static final int TYPE_IMAGE_WORD2000 = 0;
    static final int TYPE_IMAGE_PASTED_FROM_CLIPBOARD = 10;
    static final int TYPE_IMAGE_PASTED_FROM_CLIPBOARD_WORD2000 = 2;
    static final int TYPE_HORIZONTAL_LINE = 14;
    static final int BLOCK_TYPE_OFFSET = 14;
    static final int MM_MODE_TYPE_OFFSET = 6;
    private byte[] _dataStream;

    public PicturesTable(byte[] _dataStream) {
        this._dataStream = _dataStream;
    }

    public boolean hasPicture(CharacterRun run) {
        if (run.isSpecialCharacter() && !run.isObj() && !run.isOle2() && !run.isData() && "\u0001".equals(run.text())) {
            return this.isBlockContainsImage(run.getPicOffset());
        }
        return false;
    }

    public boolean hasHorizontalLine(CharacterRun run) {
        if (run.isSpecialCharacter() && "\u0001".equals(run.text())) {
            return this.isBlockContainsHorizontalLine(run.getPicOffset());
        }
        return false;
    }

    private boolean isPictureRecognized(short blockType, short mappingModeOfMETAFILEPICT) {
        return blockType == 8 || blockType == 10 || blockType == 0 && mappingModeOfMETAFILEPICT == 100 || blockType == 2 && mappingModeOfMETAFILEPICT == 100;
    }

    private static short getBlockType(byte[] dataStream, int pictOffset) {
        return LittleEndian.getShort((byte[])dataStream, (int)(pictOffset + 14));
    }

    private static short getMmMode(byte[] dataStream, int pictOffset) {
        return LittleEndian.getShort((byte[])dataStream, (int)(pictOffset + 6));
    }

    public Picture extractPicture(CharacterRun run, boolean fillBytes) {
        if (this.hasPicture(run)) {
            return new Picture(run.getPicOffset(), this._dataStream, fillBytes);
        }
        return null;
    }

    public List getAllPictures() {
        int skipOn;
        ArrayList<Picture> pictures = new ArrayList<Picture>();
        boolean atEnd = false;
        for (int pos = 0; pos < this._dataStream.length && !atEnd; pos += skipOn) {
            if (this.isBlockContainsImage(pos)) {
                pictures.add(new Picture(pos, this._dataStream, false));
            }
            if ((skipOn = LittleEndian.getInt((byte[])this._dataStream, (int)pos)) > 0) continue;
            atEnd = true;
        }
        return pictures;
    }

    private boolean isBlockContainsImage(int i) {
        return this.isPictureRecognized(PicturesTable.getBlockType(this._dataStream, i), PicturesTable.getMmMode(this._dataStream, i));
    }

    private boolean isBlockContainsHorizontalLine(int i) {
        return PicturesTable.getBlockType(this._dataStream, i) == 14 && PicturesTable.getMmMode(this._dataStream, i) == 100;
    }
}

