/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.poi.hssf.model.FormulaParser;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ControlPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.MemErrPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NameXPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.ReferencePtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.record.formula.UnknownPtg;
import org.apache.poi.hssf.record.formula.eval.Area2DEval;
import org.apache.poi.hssf.record.formula.eval.Area3DEval;
import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.Ref2DEval;
import org.apache.poi.hssf.record.formula.eval.Ref3DEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class HSSFFormulaEvaluator {
    private static final Class[] OPERATION_CONSTRUCTOR_CLASS_ARRAY = new Class[]{class$org$apache$poi$hssf$record$formula$Ptg == null ? (class$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.Ptg")) : class$org$apache$poi$hssf$record$formula$Ptg};
    private static final Class[] VALUE_CONTRUCTOR_CLASS_ARRAY = new Class[]{class$org$apache$poi$hssf$record$formula$Ptg == null ? (class$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.Ptg")) : class$org$apache$poi$hssf$record$formula$Ptg};
    private static final Class[] AREA3D_CONSTRUCTOR_CLASS_ARRAY = new Class[]{class$org$apache$poi$hssf$record$formula$Ptg == null ? (class$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.Ptg")) : class$org$apache$poi$hssf$record$formula$Ptg, array$Lorg$apache$poi$hssf$record$formula$eval$ValueEval == null ? (array$Lorg$apache$poi$hssf$record$formula$eval$ValueEval = HSSFFormulaEvaluator.class$("[Lorg.apache.poi.hssf.record.formula.eval.ValueEval;")) : array$Lorg$apache$poi$hssf$record$formula$eval$ValueEval};
    private static final Class[] REFERENCE_CONSTRUCTOR_CLASS_ARRAY = new Class[]{class$org$apache$poi$hssf$record$formula$Ptg == null ? (class$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.Ptg")) : class$org$apache$poi$hssf$record$formula$Ptg, class$org$apache$poi$hssf$record$formula$eval$ValueEval == null ? (class$org$apache$poi$hssf$record$formula$eval$ValueEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.ValueEval")) : class$org$apache$poi$hssf$record$formula$eval$ValueEval};
    private static final Class[] REF3D_CONSTRUCTOR_CLASS_ARRAY = new Class[]{class$org$apache$poi$hssf$record$formula$Ptg == null ? (class$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.Ptg")) : class$org$apache$poi$hssf$record$formula$Ptg, class$org$apache$poi$hssf$record$formula$eval$ValueEval == null ? (class$org$apache$poi$hssf$record$formula$eval$ValueEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.ValueEval")) : class$org$apache$poi$hssf$record$formula$eval$ValueEval};
    private static final Map VALUE_EVALS_MAP = new HashMap();
    private static final Map OPERATION_EVALS_MAP = new HashMap();
    protected HSSFRow row;
    protected HSSFSheet sheet;
    protected HSSFWorkbook workbook;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$Ptg;
    static /* synthetic */ Class array$Lorg$apache$poi$hssf$record$formula$eval$ValueEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$ValueEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$BoolPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$BoolEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$IntPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$NumberEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$NumberPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$StringPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$StringEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$AddPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$AddEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$ConcatPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$ConcatEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$DividePtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$DivideEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$EqualPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$EqualEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$FuncPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$FuncVarEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$FuncVarPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$GreaterEqualPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$GreaterEqualEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$GreaterThanPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$GreaterThanEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$LessEqualPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$LessEqualEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$LessThanPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$LessThanEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$MultiplyPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$MultiplyEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$NotEqualPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$NotEqualEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$PowerPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$PowerEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$SubtractPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$SubtractEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$UnaryMinusPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$UnaryMinusEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$UnaryPlusPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$UnaryPlusEval;

    public HSSFFormulaEvaluator(HSSFSheet sheet, HSSFWorkbook workbook) {
        this.sheet = sheet;
        this.workbook = workbook;
    }

    public void setCurrentRow(HSSFRow row) {
        this.row = row;
    }

    public static FormulaParser getUnderlyingParser(HSSFWorkbook workbook, String formula) {
        return new FormulaParser(formula, workbook.getWorkbook());
    }

    public CellValue evaluate(HSSFCell cell) {
        CellValue retval = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 3: {
                    retval = new CellValue(3);
                    break;
                }
                case 4: {
                    retval = new CellValue(4);
                    retval.setBooleanValue(cell.getBooleanCellValue());
                    break;
                }
                case 5: {
                    retval = new CellValue(5);
                    retval.setErrorValue(cell.getErrorCellValue());
                    break;
                }
                case 2: {
                    retval = HSSFFormulaEvaluator.getCellValueForEval(HSSFFormulaEvaluator.internalEvaluate(cell, this.row, this.sheet, this.workbook));
                    break;
                }
                case 0: {
                    retval = new CellValue(0);
                    retval.setNumberValue(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    retval = new CellValue(1);
                    retval.setRichTextStringValue(cell.getRichStringCellValue());
                }
            }
        }
        return retval;
    }

    public int evaluateFormulaCell(HSSFCell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case 2: {
                    CellValue cv = HSSFFormulaEvaluator.getCellValueForEval(HSSFFormulaEvaluator.internalEvaluate(cell, this.row, this.sheet, this.workbook));
                    switch (cv.getCellType()) {
                        case 4: {
                            cell.setCellValue(cv.getBooleanValue());
                            break;
                        }
                        case 5: {
                            cell.setCellValue((double)cv.getErrorValue());
                            break;
                        }
                        case 0: {
                            cell.setCellValue(cv.getNumberValue());
                            break;
                        }
                        case 1: {
                            cell.setCellValue(cv.getRichTextStringValue());
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    return cv.getCellType();
                }
            }
        }
        return -1;
    }

    public HSSFCell evaluateInCell(HSSFCell cell) {
        if (cell != null) {
            block0 : switch (cell.getCellType()) {
                case 2: {
                    CellValue cv = HSSFFormulaEvaluator.getCellValueForEval(HSSFFormulaEvaluator.internalEvaluate(cell, this.row, this.sheet, this.workbook));
                    switch (cv.getCellType()) {
                        case 4: {
                            cell.setCellType(4);
                            cell.setCellValue(cv.getBooleanValue());
                            break block0;
                        }
                        case 5: {
                            cell.setCellType(5);
                            cell.setCellValue((double)cv.getErrorValue());
                            break block0;
                        }
                        case 0: {
                            cell.setCellType(0);
                            cell.setCellValue(cv.getNumberValue());
                            break block0;
                        }
                        case 1: {
                            cell.setCellType(1);
                            cell.setCellValue(cv.getRichTextStringValue());
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                }
            }
        }
        return cell;
    }

    protected static CellValue getCellValueForEval(ValueEval eval) {
        CellValue retval = null;
        if (eval != null) {
            if (eval instanceof NumberEval) {
                NumberEval ne = (NumberEval)eval;
                retval = new CellValue(0);
                retval.setNumberValue(ne.getNumberValue());
            } else if (eval instanceof BoolEval) {
                BoolEval be = (BoolEval)eval;
                retval = new CellValue(4);
                retval.setBooleanValue(be.getBooleanValue());
            } else if (eval instanceof StringEval) {
                StringEval ne = (StringEval)eval;
                retval = new CellValue(1);
                retval.setStringValue(ne.getStringValue());
            } else {
                retval = eval instanceof BlankEval ? new CellValue(3) : new CellValue(5);
            }
        }
        return retval;
    }

    protected static ValueEval internalEvaluate(HSSFCell srcCell, HSSFRow srcRow, HSSFSheet sheet, HSSFWorkbook workbook) {
        int srcRowNum = srcRow.getRowNum();
        short srcColNum = srcCell.getCellNum();
        FormulaParser parser = new FormulaParser(srcCell.getCellFormula(), workbook.getWorkbook());
        parser.parse();
        Ptg[] ptgs = parser.getRPNPtg();
        Stack<Eval> stack = new Stack<Eval>();
        int iSize = ptgs.length;
        for (int i = 0; i < iSize; ++i) {
            short col0;
            short rownum;
            ReferencePtg ptg;
            if (ptgs[i] instanceof ControlPtg || ptgs[i] instanceof MemErrPtg || ptgs[i] instanceof MissingArgPtg || ptgs[i] instanceof NamePtg || ptgs[i] instanceof NameXPtg || ptgs[i] instanceof UnknownPtg) continue;
            if (ptgs[i] instanceof OperationPtg) {
                OperationPtg optg = (OperationPtg)ptgs[i];
                if (optg instanceof ParenthesisPtg || optg instanceof AttrPtg || optg instanceof UnionPtg) continue;
                OperationEval operation = (OperationEval)HSSFFormulaEvaluator.getOperationEvalForPtg(optg);
                int numops = operation.getNumberOfOperands();
                Eval[] ops = new Eval[numops];
                for (int j = numops - 1; j >= 0; --j) {
                    Eval p;
                    ops[j] = p = (Eval)stack.pop();
                }
                Eval opresult = operation.evaluate(ops, srcRowNum, srcColNum);
                stack.push(opresult);
                continue;
            }
            if (ptgs[i] instanceof ReferencePtg) {
                ptg = (ReferencePtg)ptgs[i];
                short colnum = ptg.getColumn();
                rownum = ptg.getRow();
                HSSFRow row = sheet.getRow((int)rownum);
                HSSFCell cell = row != null ? row.getCell(colnum) : null;
                HSSFFormulaEvaluator.pushRef2DEval(ptg, stack, cell, row, sheet, workbook);
                continue;
            }
            if (ptgs[i] instanceof Ref3DPtg) {
                ptg = (Ref3DPtg)ptgs[i];
                short colnum = ptg.getColumn();
                rownum = ptg.getRow();
                Workbook wb = workbook.getWorkbook();
                HSSFSheet xsheet = workbook.getSheetAt(wb.getSheetIndexFromExternSheetIndex((int)ptg.getExternSheetIndex()));
                HSSFRow row = xsheet.getRow((int)rownum);
                HSSFCell cell = row != null ? row.getCell(colnum) : null;
                HSSFFormulaEvaluator.pushRef3DEval((Ref3DPtg)ptg, stack, cell, row, xsheet, workbook);
                continue;
            }
            if (ptgs[i] instanceof AreaPtg) {
                AreaPtg ap = (AreaPtg)ptgs[i];
                short row0 = ap.getFirstRow();
                col0 = ap.getFirstColumn();
                short row1 = ap.getLastRow();
                short col1 = ap.getLastColumn();
                ValueEval[] values = new ValueEval[(row1 - row0 + 1) * (col1 - col0 + 1)];
                for (short x = row0; sheet != null && x < row1 + 1; x = (short)(x + 1)) {
                    HSSFRow row = sheet.getRow((int)x);
                    for (short y = col0; row != null && y < col1 + 1; y = (short)(y + 1)) {
                        values[(x - row0) * (col1 - col0 + 1) + (y - col0)] = HSSFFormulaEvaluator.getEvalForCell(row.getCell(y), row, sheet, workbook);
                    }
                }
                Area2DEval ae = new Area2DEval((Ptg)ap, values);
                stack.push(ae);
                continue;
            }
            if (ptgs[i] instanceof Area3DPtg) {
                Area3DPtg a3dp = (Area3DPtg)ptgs[i];
                short row0 = a3dp.getFirstRow();
                col0 = a3dp.getFirstColumn();
                short row1 = a3dp.getLastRow();
                short col1 = a3dp.getLastColumn();
                Workbook wb = workbook.getWorkbook();
                HSSFSheet xsheet = workbook.getSheetAt(wb.getSheetIndexFromExternSheetIndex((int)a3dp.getExternSheetIndex()));
                ValueEval[] values = new ValueEval[(row1 - row0 + 1) * (col1 - col0 + 1)];
                for (short x = row0; xsheet != null && x < row1 + 1; x = (short)(x + 1)) {
                    HSSFRow row = xsheet.getRow((int)x);
                    for (short y = col0; row != null && y < col1 + 1; y = (short)(y + 1)) {
                        values[(x - row0) * (col1 - col0 + 1) + (y - col0)] = HSSFFormulaEvaluator.getEvalForCell(row.getCell(y), row, xsheet, workbook);
                    }
                }
                Area3DEval ae = new Area3DEval((Ptg)a3dp, values);
                stack.push(ae);
                continue;
            }
            Eval ptgEval = HSSFFormulaEvaluator.getEvalForPtg(ptgs[i]);
            stack.push(ptgEval);
        }
        ValueEval value = (ValueEval)stack.pop();
        if (value instanceof RefEval) {
            RefEval rv = (RefEval)value;
            value = rv.getInnerValueEval();
        } else if (value instanceof AreaEval) {
            AreaEval ae = (AreaEval)value;
            value = ae.isRow() ? ae.getValueAt(ae.getFirstRow(), srcColNum) : (ae.isColumn() ? ae.getValueAt(srcRowNum, ae.getFirstColumn()) : ErrorEval.VALUE_INVALID);
        }
        return value;
    }

    protected static Eval getOperationEvalForPtg(OperationPtg ptg) {
        OperationEval retval = null;
        Class clazz = (Class)OPERATION_EVALS_MAP.get(ptg.getClass());
        try {
            Constructor constructor = clazz.getConstructor(OPERATION_CONSTRUCTOR_CLASS_ARRAY);
            retval = (OperationEval)constructor.newInstance(ptg);
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal Error: ", e);
        }
        return retval;
    }

    protected static Eval getEvalForPtg(Ptg ptg) {
        Eval retval = null;
        Class clazz = (Class)VALUE_EVALS_MAP.get(ptg.getClass());
        try {
            if (ptg instanceof Area3DPtg) {
                Constructor constructor = clazz.getConstructor(AREA3D_CONSTRUCTOR_CLASS_ARRAY);
                retval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof AreaPtg) {
                Constructor constructor = clazz.getConstructor(AREA3D_CONSTRUCTOR_CLASS_ARRAY);
                retval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof ReferencePtg) {
                Constructor constructor = clazz.getConstructor(REFERENCE_CONSTRUCTOR_CLASS_ARRAY);
                retval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof Ref3DPtg) {
                Constructor constructor = clazz.getConstructor(REF3D_CONSTRUCTOR_CLASS_ARRAY);
                retval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof IntPtg || ptg instanceof NumberPtg || ptg instanceof StringPtg || ptg instanceof BoolPtg) {
                Constructor constructor = clazz.getConstructor(VALUE_CONTRUCTOR_CLASS_ARRAY);
                retval = (ValueEval)constructor.newInstance(ptg);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal Error: ", e);
        }
        return retval;
    }

    protected static ValueEval getEvalForCell(HSSFCell cell, HSSFRow row, HSSFSheet sheet, HSSFWorkbook workbook) {
        ValueEval retval = BlankEval.INSTANCE;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: {
                    retval = new NumberEval(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    retval = new StringEval(cell.getRichStringCellValue().getString());
                    break;
                }
                case 2: {
                    retval = HSSFFormulaEvaluator.internalEvaluate(cell, row, sheet, workbook);
                    break;
                }
                case 4: {
                    retval = cell.getBooleanCellValue() ? BoolEval.TRUE : BoolEval.FALSE;
                    break;
                }
                case 3: {
                    retval = BlankEval.INSTANCE;
                    break;
                }
                case 5: {
                    retval = ErrorEval.UNKNOWN_ERROR;
                }
            }
        }
        return retval;
    }

    protected static void pushRef2DEval(ReferencePtg ptg, Stack stack, HSSFCell cell, HSSFRow row, HSSFSheet sheet, HSSFWorkbook workbook) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: {
                    stack.push(new Ref2DEval((Ptg)ptg, new NumberEval(cell.getNumericCellValue()), false));
                    break;
                }
                case 1: {
                    stack.push(new Ref2DEval((Ptg)ptg, new StringEval(cell.getRichStringCellValue().getString()), false));
                    break;
                }
                case 2: {
                    stack.push(new Ref2DEval((Ptg)ptg, HSSFFormulaEvaluator.internalEvaluate(cell, row, sheet, workbook), true));
                    break;
                }
                case 4: {
                    stack.push(new Ref2DEval((Ptg)ptg, cell.getBooleanCellValue() ? BoolEval.TRUE : BoolEval.FALSE, false));
                    break;
                }
                case 3: {
                    stack.push(new Ref2DEval((Ptg)ptg, BlankEval.INSTANCE, false));
                    break;
                }
                case 5: {
                    stack.push(new Ref2DEval((Ptg)ptg, ErrorEval.UNKNOWN_ERROR, false));
                }
            }
        } else {
            stack.push(new Ref2DEval((Ptg)ptg, BlankEval.INSTANCE, false));
        }
    }

    protected static void pushRef3DEval(Ref3DPtg ptg, Stack stack, HSSFCell cell, HSSFRow row, HSSFSheet sheet, HSSFWorkbook workbook) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: {
                    stack.push(new Ref3DEval((Ptg)ptg, new NumberEval(cell.getNumericCellValue()), false));
                    break;
                }
                case 1: {
                    stack.push(new Ref3DEval((Ptg)ptg, new StringEval(cell.getRichStringCellValue().getString()), false));
                    break;
                }
                case 2: {
                    stack.push(new Ref3DEval((Ptg)ptg, HSSFFormulaEvaluator.internalEvaluate(cell, row, sheet, workbook), true));
                    break;
                }
                case 4: {
                    stack.push(new Ref3DEval((Ptg)ptg, cell.getBooleanCellValue() ? BoolEval.TRUE : BoolEval.FALSE, false));
                    break;
                }
                case 3: {
                    stack.push(new Ref3DEval((Ptg)ptg, BlankEval.INSTANCE, false));
                    break;
                }
                case 5: {
                    stack.push(new Ref3DEval((Ptg)ptg, ErrorEval.UNKNOWN_ERROR, false));
                }
            }
        } else {
            stack.push(new Ref3DEval((Ptg)ptg, BlankEval.INSTANCE, false));
        }
    }

    void inspectPtgs(String formula) {
        FormulaParser fp = new FormulaParser(formula, this.workbook.getWorkbook());
        fp.parse();
        Ptg[] ptgs = fp.getRPNPtg();
        System.out.println("<ptg-group>");
        int iSize = ptgs.length;
        for (int i = 0; i < iSize; ++i) {
            System.out.println("<ptg>");
            System.out.println(ptgs[i]);
            if (ptgs[i] instanceof OperationPtg) {
                System.out.println("numoperands: " + ((OperationPtg)ptgs[i]).getNumberOfOperands());
            }
            System.out.println("</ptg>");
        }
        System.out.println("</ptg-group>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        VALUE_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$BoolPtg == null ? (class$org$apache$poi$hssf$record$formula$BoolPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.BoolPtg")) : class$org$apache$poi$hssf$record$formula$BoolPtg, class$org$apache$poi$hssf$record$formula$eval$BoolEval == null ? (class$org$apache$poi$hssf$record$formula$eval$BoolEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.BoolEval")) : class$org$apache$poi$hssf$record$formula$eval$BoolEval);
        VALUE_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$IntPtg == null ? (class$org$apache$poi$hssf$record$formula$IntPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.IntPtg")) : class$org$apache$poi$hssf$record$formula$IntPtg, class$org$apache$poi$hssf$record$formula$eval$NumberEval == null ? (class$org$apache$poi$hssf$record$formula$eval$NumberEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.NumberEval")) : class$org$apache$poi$hssf$record$formula$eval$NumberEval);
        VALUE_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$NumberPtg == null ? (class$org$apache$poi$hssf$record$formula$NumberPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.NumberPtg")) : class$org$apache$poi$hssf$record$formula$NumberPtg, class$org$apache$poi$hssf$record$formula$eval$NumberEval == null ? (class$org$apache$poi$hssf$record$formula$eval$NumberEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.NumberEval")) : class$org$apache$poi$hssf$record$formula$eval$NumberEval);
        VALUE_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$StringPtg == null ? (class$org$apache$poi$hssf$record$formula$StringPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.StringPtg")) : class$org$apache$poi$hssf$record$formula$StringPtg, class$org$apache$poi$hssf$record$formula$eval$StringEval == null ? (class$org$apache$poi$hssf$record$formula$eval$StringEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.StringEval")) : class$org$apache$poi$hssf$record$formula$eval$StringEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$AddPtg == null ? (class$org$apache$poi$hssf$record$formula$AddPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.AddPtg")) : class$org$apache$poi$hssf$record$formula$AddPtg, class$org$apache$poi$hssf$record$formula$eval$AddEval == null ? (class$org$apache$poi$hssf$record$formula$eval$AddEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.AddEval")) : class$org$apache$poi$hssf$record$formula$eval$AddEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$ConcatPtg == null ? (class$org$apache$poi$hssf$record$formula$ConcatPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.ConcatPtg")) : class$org$apache$poi$hssf$record$formula$ConcatPtg, class$org$apache$poi$hssf$record$formula$eval$ConcatEval == null ? (class$org$apache$poi$hssf$record$formula$eval$ConcatEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.ConcatEval")) : class$org$apache$poi$hssf$record$formula$eval$ConcatEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$DividePtg == null ? (class$org$apache$poi$hssf$record$formula$DividePtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.DividePtg")) : class$org$apache$poi$hssf$record$formula$DividePtg, class$org$apache$poi$hssf$record$formula$eval$DivideEval == null ? (class$org$apache$poi$hssf$record$formula$eval$DivideEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.DivideEval")) : class$org$apache$poi$hssf$record$formula$eval$DivideEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$EqualPtg == null ? (class$org$apache$poi$hssf$record$formula$EqualPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.EqualPtg")) : class$org$apache$poi$hssf$record$formula$EqualPtg, class$org$apache$poi$hssf$record$formula$eval$EqualEval == null ? (class$org$apache$poi$hssf$record$formula$eval$EqualEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.EqualEval")) : class$org$apache$poi$hssf$record$formula$eval$EqualEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$FuncPtg == null ? (class$org$apache$poi$hssf$record$formula$FuncPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.FuncPtg")) : class$org$apache$poi$hssf$record$formula$FuncPtg, class$org$apache$poi$hssf$record$formula$eval$FuncVarEval == null ? (class$org$apache$poi$hssf$record$formula$eval$FuncVarEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.FuncVarEval")) : class$org$apache$poi$hssf$record$formula$eval$FuncVarEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$FuncVarPtg == null ? (class$org$apache$poi$hssf$record$formula$FuncVarPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.FuncVarPtg")) : class$org$apache$poi$hssf$record$formula$FuncVarPtg, class$org$apache$poi$hssf$record$formula$eval$FuncVarEval == null ? (class$org$apache$poi$hssf$record$formula$eval$FuncVarEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.FuncVarEval")) : class$org$apache$poi$hssf$record$formula$eval$FuncVarEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$GreaterEqualPtg == null ? (class$org$apache$poi$hssf$record$formula$GreaterEqualPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.GreaterEqualPtg")) : class$org$apache$poi$hssf$record$formula$GreaterEqualPtg, class$org$apache$poi$hssf$record$formula$eval$GreaterEqualEval == null ? (class$org$apache$poi$hssf$record$formula$eval$GreaterEqualEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.GreaterEqualEval")) : class$org$apache$poi$hssf$record$formula$eval$GreaterEqualEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$GreaterThanPtg == null ? (class$org$apache$poi$hssf$record$formula$GreaterThanPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.GreaterThanPtg")) : class$org$apache$poi$hssf$record$formula$GreaterThanPtg, class$org$apache$poi$hssf$record$formula$eval$GreaterThanEval == null ? (class$org$apache$poi$hssf$record$formula$eval$GreaterThanEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.GreaterThanEval")) : class$org$apache$poi$hssf$record$formula$eval$GreaterThanEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$LessEqualPtg == null ? (class$org$apache$poi$hssf$record$formula$LessEqualPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.LessEqualPtg")) : class$org$apache$poi$hssf$record$formula$LessEqualPtg, class$org$apache$poi$hssf$record$formula$eval$LessEqualEval == null ? (class$org$apache$poi$hssf$record$formula$eval$LessEqualEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.LessEqualEval")) : class$org$apache$poi$hssf$record$formula$eval$LessEqualEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$LessThanPtg == null ? (class$org$apache$poi$hssf$record$formula$LessThanPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.LessThanPtg")) : class$org$apache$poi$hssf$record$formula$LessThanPtg, class$org$apache$poi$hssf$record$formula$eval$LessThanEval == null ? (class$org$apache$poi$hssf$record$formula$eval$LessThanEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.LessThanEval")) : class$org$apache$poi$hssf$record$formula$eval$LessThanEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$MultiplyPtg == null ? (class$org$apache$poi$hssf$record$formula$MultiplyPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.MultiplyPtg")) : class$org$apache$poi$hssf$record$formula$MultiplyPtg, class$org$apache$poi$hssf$record$formula$eval$MultiplyEval == null ? (class$org$apache$poi$hssf$record$formula$eval$MultiplyEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.MultiplyEval")) : class$org$apache$poi$hssf$record$formula$eval$MultiplyEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$NotEqualPtg == null ? (class$org$apache$poi$hssf$record$formula$NotEqualPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.NotEqualPtg")) : class$org$apache$poi$hssf$record$formula$NotEqualPtg, class$org$apache$poi$hssf$record$formula$eval$NotEqualEval == null ? (class$org$apache$poi$hssf$record$formula$eval$NotEqualEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.NotEqualEval")) : class$org$apache$poi$hssf$record$formula$eval$NotEqualEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$PowerPtg == null ? (class$org$apache$poi$hssf$record$formula$PowerPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.PowerPtg")) : class$org$apache$poi$hssf$record$formula$PowerPtg, class$org$apache$poi$hssf$record$formula$eval$PowerEval == null ? (class$org$apache$poi$hssf$record$formula$eval$PowerEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.PowerEval")) : class$org$apache$poi$hssf$record$formula$eval$PowerEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$SubtractPtg == null ? (class$org$apache$poi$hssf$record$formula$SubtractPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.SubtractPtg")) : class$org$apache$poi$hssf$record$formula$SubtractPtg, class$org$apache$poi$hssf$record$formula$eval$SubtractEval == null ? (class$org$apache$poi$hssf$record$formula$eval$SubtractEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.SubtractEval")) : class$org$apache$poi$hssf$record$formula$eval$SubtractEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$UnaryMinusPtg == null ? (class$org$apache$poi$hssf$record$formula$UnaryMinusPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.UnaryMinusPtg")) : class$org$apache$poi$hssf$record$formula$UnaryMinusPtg, class$org$apache$poi$hssf$record$formula$eval$UnaryMinusEval == null ? (class$org$apache$poi$hssf$record$formula$eval$UnaryMinusEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.UnaryMinusEval")) : class$org$apache$poi$hssf$record$formula$eval$UnaryMinusEval);
        OPERATION_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$UnaryPlusPtg == null ? (class$org$apache$poi$hssf$record$formula$UnaryPlusPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.UnaryPlusPtg")) : class$org$apache$poi$hssf$record$formula$UnaryPlusPtg, class$org$apache$poi$hssf$record$formula$eval$UnaryPlusEval == null ? (class$org$apache$poi$hssf$record$formula$eval$UnaryPlusEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.UnaryPlusEval")) : class$org$apache$poi$hssf$record$formula$eval$UnaryPlusEval);
    }

    public static final class CellValue {
        private int cellType;
        private HSSFRichTextString richTextStringValue;
        private double numberValue;
        private boolean booleanValue;
        private byte errorValue;

        public CellValue(int cellType) {
            this.cellType = cellType;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public void setBooleanValue(boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public double getNumberValue() {
            return this.numberValue;
        }

        public void setNumberValue(double numberValue) {
            this.numberValue = numberValue;
        }

        public String getStringValue() {
            return this.richTextStringValue.getString();
        }

        public void setStringValue(String stringValue) {
            this.richTextStringValue = new HSSFRichTextString(stringValue);
        }

        public int getCellType() {
            return this.cellType;
        }

        public byte getErrorValue() {
            return this.errorValue;
        }

        public void setErrorValue(byte errorValue) {
            this.errorValue = errorValue;
        }

        public HSSFRichTextString getRichTextStringValue() {
            return this.richTextStringValue;
        }

        public void setRichTextStringValue(HSSFRichTextString richTextStringValue) {
            this.richTextStringValue = richTextStringValue;
        }
    }
}

