/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.spi.Name;

final class NameSet
implements Set,
Cloneable {
    private static final NameSetCache CACHE = new NameSetCache();
    private static final int NUM_NAMES_THRESHOLD = 5;
    private HashSet names = CACHE.getEmptySet();
    private boolean shared = true;

    NameSet() {
    }

    boolean add(Name name) {
        if (this.names.size() > 5) {
            this.ensureModifiable();
            return this.names.add(name);
        }
        int size = this.names.size();
        this.names = CACHE.get(this.names, name, !this.shared);
        this.shared = true;
        return this.names.size() != size;
    }

    boolean remove(Name name) {
        this.ensureModifiable();
        return this.names.remove(name);
    }

    void removeAll() {
        this.ensureModifiable();
        this.names.clear();
    }

    void replaceAll(Collection c) {
        if (c instanceof NameSet) {
            NameSet propNames = (NameSet)c;
            this.names = propNames.names;
            this.shared = true;
            propNames.shared = true;
        } else if (c instanceof HashSet) {
            this.names = CACHE.get((HashSet)c);
            this.shared = true;
        } else {
            this.ensureModifiable();
            this.names.clear();
            this.names.addAll(c);
        }
    }

    public int size() {
        return this.names.size();
    }

    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    public boolean contains(Object o) {
        return this.names.contains(o);
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator i;
            {
                this.i = NameSet.this.names.iterator();
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Object next() {
                return this.i.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object[] toArray() {
        return this.names.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.names.toArray(a);
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        return this.names.containsAll(c);
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object clone() {
        try {
            NameSet propNames = (NameSet)super.clone();
            this.shared = true;
            propNames.shared = true;
            return propNames;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void ensureModifiable() {
        if (this.shared) {
            this.names = (HashSet)this.names.clone();
            this.shared = false;
        }
    }

    private static final class NameSetCache {
        private static final int SIZE_POWER_OF_2 = 1024;
        private final HashSet[] array = new HashSet[1024];

        private NameSetCache() {
        }

        public HashSet get(HashSet set, Object obj, boolean modifiable) {
            if (set.contains(obj)) {
                return set;
            }
            int position = set.hashCode() + obj.hashCode() & 0x3FF;
            HashSet previous = this.array[position];
            if (previous != null && previous.size() == set.size() + 1 && previous.containsAll(set) && previous.contains(obj)) {
                return previous;
            }
            if (modifiable) {
                set.add(obj);
            } else {
                set = (HashSet)set.clone();
                set.add(obj);
            }
            this.array[position] = set;
            return set;
        }

        public HashSet get(HashSet set) {
            int position = set.hashCode() & 0x3FF;
            HashSet previous = this.array[position];
            if (set.equals(previous)) {
                return previous;
            }
            this.array[position] = set;
            return set;
        }

        public HashSet getEmptySet() {
            HashSet set = this.array[0];
            if (set == null || !set.isEmpty()) {
                this.array[0] = set = new HashSet();
            }
            return set;
        }
    }
}

