/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public final class PrivilegeRegistry {
    private static final Set REGISTERED_PRIVILEGES = new HashSet(10);
    private static final Map BITS_TO_PRIVILEGES = new HashMap();
    private static final NameFactory NAME_FACTORY = NameFactoryImpl.getInstance();
    private static final Privilege[] EMPTY_ARRAY = new Privilege[0];
    public static final int NO_PRIVILEGE = 0;
    public static final int READ = 1;
    public static final int MODIFY_PROPERTIES = 2;
    public static final int ADD_CHILD_NODES = 4;
    public static final int REMOVE_CHILD_NODES = 8;
    public static final int REMOVE_NODE = 16;
    public static final int READ_AC = 32;
    public static final int MODIFY_AC = 64;
    public static final int WRITE = 14;
    public static final int ALL = 127;
    private static final InternalPrivilege READ_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}read", 1));
    private static final InternalPrivilege MODIFY_PROPERTIES_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}modifyProperties", 2));
    private static final InternalPrivilege ADD_CHILD_NODES_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}addChildNodes", 4));
    private static final InternalPrivilege REMOVE_CHILD_NODES_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}removeChildNodes", 8));
    private static final InternalPrivilege REMOVE_NODE_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}removeNode", 16));
    private static final InternalPrivilege READ_AC_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}readAccessControl", 32));
    private static final InternalPrivilege MODIFY_AC_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}modifyAccessControl", 64));
    private static final InternalPrivilege WRITE_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}write", new InternalPrivilege[]{MODIFY_PROPERTIES_PRIVILEGE, ADD_CHILD_NODES_PRIVILEGE, REMOVE_CHILD_NODES_PRIVILEGE}));
    private static final InternalPrivilege ALL_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}all", new InternalPrivilege[]{READ_PRIVILEGE, WRITE_PRIVILEGE, REMOVE_NODE_PRIVILEGE, READ_AC_PRIVILEGE, MODIFY_AC_PRIVILEGE}));
    private final NameResolver resolver;
    private final Map localCache;

    public PrivilegeRegistry(NameResolver resolver) {
        this.resolver = resolver;
        this.localCache = new HashMap(REGISTERED_PRIVILEGES.size());
        Iterator it = REGISTERED_PRIVILEGES.iterator();
        while (it.hasNext()) {
            InternalPrivilege ip = (InternalPrivilege)it.next();
            PrivilegeImpl priv = new PrivilegeImpl(ip, resolver);
            this.localCache.put(ip.name, priv);
        }
    }

    public Privilege[] getRegisteredPrivileges() {
        return this.localCache.values().toArray(new Privilege[this.localCache.size()]);
    }

    public Privilege getPrivilege(String privilegeName) throws AccessControlException, RepositoryException {
        Name name = this.resolver.getQName(privilegeName);
        if (this.localCache.containsKey(name)) {
            return (Privilege)this.localCache.get(name);
        }
        throw new AccessControlException("Unknown privilege " + privilegeName);
    }

    public Privilege[] getPrivileges(int bits) {
        Privilege[] privs;
        if (bits > 0) {
            InternalPrivilege[] internalPrivs = PrivilegeRegistry.getInteralPrivileges(bits);
            privs = new Privilege[internalPrivs.length];
            for (int i = 0; i < internalPrivs.length; ++i) {
                privs[i] = (Privilege)this.localCache.get(internalPrivs[i].name);
            }
        } else {
            privs = new Privilege[]{};
        }
        return privs;
    }

    public static int getBits(Privilege[] privileges) throws AccessControlException {
        if (privileges == null || privileges.length == 0) {
            throw new AccessControlException();
        }
        int bits = 0;
        for (int i = 0; i < privileges.length; ++i) {
            Privilege priv = privileges[i];
            if (priv instanceof PrivilegeImpl) {
                bits |= ((PrivilegeImpl)priv).internalPrivilege.getBits();
                continue;
            }
            throw new AccessControlException("Unknown privilege '" + priv.getName() + "'.");
        }
        return bits;
    }

    private static InternalPrivilege[] getInteralPrivileges(int bits) {
        InternalPrivilege[] privs;
        Integer key = new Integer(bits);
        if (BITS_TO_PRIVILEGES.containsKey(key)) {
            return (InternalPrivilege[])BITS_TO_PRIVILEGES.get(key);
        }
        ArrayList<InternalPrivilege> privileges = new ArrayList<InternalPrivilege>();
        if ((bits & 1) == 1) {
            privileges.add(READ_PRIVILEGE);
        }
        if ((bits & 0xE) == 14) {
            privileges.add(WRITE_PRIVILEGE);
        } else {
            if ((bits & 2) == 2) {
                privileges.add(MODIFY_PROPERTIES_PRIVILEGE);
            }
            if ((bits & 4) == 4) {
                privileges.add(ADD_CHILD_NODES_PRIVILEGE);
            }
            if ((bits & 8) == 8) {
                privileges.add(REMOVE_CHILD_NODES_PRIVILEGE);
            }
        }
        if ((bits & 0x10) == 16) {
            privileges.add(REMOVE_NODE_PRIVILEGE);
        }
        if ((bits & 0x20) == 32) {
            privileges.add(READ_AC_PRIVILEGE);
        }
        if ((bits & 0x40) == 64) {
            privileges.add(MODIFY_AC_PRIVILEGE);
        }
        if (!privileges.isEmpty()) {
            privs = privileges.toArray(new InternalPrivilege[privileges.size()]);
            BITS_TO_PRIVILEGES.put(key, privs);
        } else {
            privs = new InternalPrivilege[]{};
        }
        return privs;
    }

    private static InternalPrivilege registerPrivilege(InternalPrivilege privilege) {
        REGISTERED_PRIVILEGES.add(privilege);
        BITS_TO_PRIVILEGES.put(new Integer(privilege.getBits()), new InternalPrivilege[]{privilege});
        return privilege;
    }

    private class PrivilegeImpl
    implements Privilege {
        private final InternalPrivilege internalPrivilege;
        private final NameResolver resolver;

        private PrivilegeImpl(InternalPrivilege internalPrivilege, NameResolver resolver) {
            this.internalPrivilege = internalPrivilege;
            this.resolver = resolver;
        }

        public String getName() {
            try {
                return this.resolver.getJCRName(this.internalPrivilege.name);
            }
            catch (NamespaceException e) {
                return this.internalPrivilege.name.toString();
            }
        }

        public boolean isAbstract() {
            return false;
        }

        public boolean isAggregate() {
            return this.internalPrivilege.isAggregate;
        }

        public Privilege[] getDeclaredAggregatePrivileges() {
            if (this.internalPrivilege.isAggregate) {
                int len = this.internalPrivilege.declaredAggregates.length;
                Privilege[] privs = new Privilege[len];
                for (int i = 0; i < len; ++i) {
                    InternalPrivilege ip = this.internalPrivilege.declaredAggregates[i];
                    privs[i] = (Privilege)PrivilegeRegistry.this.localCache.get(ip.name);
                }
                return privs;
            }
            return EMPTY_ARRAY;
        }

        public Privilege[] getAggregatePrivileges() {
            if (this.internalPrivilege.isAggregate) {
                Privilege[] privs = new Privilege[this.internalPrivilege.aggregates.size()];
                int i = 0;
                Iterator it = this.internalPrivilege.aggregates.iterator();
                while (it.hasNext()) {
                    InternalPrivilege ip = (InternalPrivilege)it.next();
                    privs[i++] = (Privilege)PrivilegeRegistry.this.localCache.get(ip.name);
                }
                return privs;
            }
            return EMPTY_ARRAY;
        }

        public int hashCode() {
            return this.internalPrivilege.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PrivilegeImpl) {
                PrivilegeImpl other = (PrivilegeImpl)obj;
                return this.internalPrivilege.equals(other.internalPrivilege);
            }
            return false;
        }
    }

    private static class InternalPrivilege {
        private final Name name;
        private final boolean isAbstract = false;
        private final boolean isAggregate;
        private final InternalPrivilege[] declaredAggregates;
        private final Set aggregates;
        private final int bits;

        private InternalPrivilege(String name, int bits) {
            if (name == null) {
                throw new IllegalArgumentException("A privilege must have a name.");
            }
            this.name = NAME_FACTORY.create(name);
            this.bits = bits;
            this.declaredAggregates = null;
            this.aggregates = null;
            this.isAggregate = false;
        }

        private InternalPrivilege(String name, InternalPrivilege[] declaredAggregates) {
            if (name == null) {
                throw new IllegalArgumentException("A privilege must have a name.");
            }
            this.name = NAME_FACTORY.create(name);
            this.declaredAggregates = declaredAggregates;
            HashSet<InternalPrivilege> aggrgt = new HashSet<InternalPrivilege>();
            int bts = 0;
            for (int i = 0; i < declaredAggregates.length; ++i) {
                InternalPrivilege priv = declaredAggregates[i];
                bts |= priv.getBits();
                if (priv.isAggregate) {
                    aggrgt.addAll(priv.aggregates);
                    continue;
                }
                aggrgt.add(priv);
            }
            this.aggregates = Collections.unmodifiableSet(aggrgt);
            this.bits = bts;
            this.isAggregate = true;
        }

        int getBits() {
            return this.bits;
        }

        public int hashCode() {
            return this.bits;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof InternalPrivilege) {
                return this.bits == ((InternalPrivilege)obj).bits;
            }
            return false;
        }
    }
}

