/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.stanza.dataforms;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLText;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.stanza.dataforms.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFormParser {
    private final Logger logger = LoggerFactory.getLogger(DataFormParser.class);
    protected XMLElement form;

    public static Object extractFieldValue(String valueAsString, Field.Type fieldType) throws IllegalArgumentException {
        Object value = null;
        if (fieldType == null) {
            return valueAsString;
        }
        switch (fieldType) {
            case LIST_MULTI: 
            case LIST_SINGLE: 
            case TEXT_MULTI: 
            case TEXT_PRIVATE: 
            case TEXT_SINGLE: 
            case HIDDEN: 
            case FIXED: {
                value = valueAsString;
                break;
            }
            case BOOLEAN: {
                value = "0".equals(valueAsString) || "true".equals(valueAsString);
                break;
            }
            case JID_MULTI: 
            case JID_SINGLE: {
                try {
                    value = EntityImpl.parse(valueAsString);
                    break;
                }
                catch (EntityFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return value;
    }

    public DataFormParser(XMLElement form) {
        this.form = form;
    }

    public Map<String, Object> extractFieldValues() throws IllegalArgumentException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (XMLElement fields : this.form.getInnerElementsNamed("field")) {
            boolean isMulti;
            String varName = fields.getAttributeValue("var");
            String typeName = fields.getAttributeValue("type");
            String valueAsString = null;
            Field.Type fieldType = Field.Type.TEXT_SINGLE;
            if (typeName != null) {
                fieldType = Field.Type.valueOf(typeName.toUpperCase().replace('-', '_'));
            }
            ArrayList<Object> values = (isMulti = Field.Type.isMulti(fieldType)) ? new ArrayList<Object>() : null;
            for (XMLElement valueCandidates : fields.getInnerElementsNamed("value")) {
                Object value;
                XMLText firstInnerText = valueCandidates.getFirstInnerText();
                if (firstInnerText != null) {
                    valueAsString = firstInnerText.getText();
                }
                try {
                    value = DataFormParser.extractFieldValue(valueAsString, fieldType);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("malformed field value for field = " + varName + " and raw value = " + valueAsString);
                    continue;
                }
                if (!isMulti) {
                    map.put(varName, value);
                    break;
                }
                values.add(value);
            }
            if (!isMulti) continue;
            map.put(varName, values);
        }
        return map;
    }
}

