/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0133_service_administration.command;

import java.util.List;
import java.util.Map;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AccountCreationException;
import org.apache.vysper.xmpp.authorization.AccountManagement;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.Note;
import org.apache.vysper.xmpp.modules.extension.xep0133_service_administration.command.PasswordCheckingCommandHandler;
import org.apache.vysper.xmpp.stanza.dataforms.DataForm;
import org.apache.vysper.xmpp.stanza.dataforms.DataFormParser;
import org.apache.vysper.xmpp.stanza.dataforms.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeUserPasswordCommandHandler
extends PasswordCheckingCommandHandler {
    protected AccountManagement accountManagement;
    protected Entity constrainedJID;

    public ChangeUserPasswordCommandHandler(AccountManagement accountManagement, Entity constrainedJID) {
        this.accountManagement = accountManagement;
        this.constrainedJID = constrainedJID;
    }

    @Override
    public XMLElement process(List<XMLElement> commandElements, List<Note> notes) {
        if (commandElements == null || commandElements.size() == 0) {
            return this.sendForm();
        }
        return this.processForm(commandElements, notes);
    }

    protected XMLElement sendForm() {
        DataForm dataForm = this.createFormForm("Changing a User Password", "Fill out this form to change a user&apos;s password.");
        if (this.constrainedJID == null) {
            dataForm.addField(new Field("The Jabber ID whose password will be changed.", Field.Type.JID_SINGLE, "accountjid"));
        } else {
            dataForm.addField(new Field("The Jabber ID whose password will be changed.", Field.Type.JID_SINGLE, "accountjid", this.constrainedJID.getFullQualifiedName()));
        }
        dataForm.addField(new Field("The new password for this account", Field.Type.TEXT_PRIVATE, "password"));
        dataForm.addField(new Field("Retype new password", Field.Type.TEXT_PRIVATE, "password-verify"));
        return DATA_FORM_ENCODER.getXML(dataForm);
    }

    protected XMLElement processForm(List<XMLElement> commandElements, List<Note> notes) {
        String password2;
        String password;
        if (commandElements.size() != 1) {
            throw new IllegalStateException("must be an X element");
        }
        DataFormParser dataFormParser = new DataFormParser(commandElements.get(0));
        Map<String, Object> valueMap = dataFormParser.extractFieldValues();
        Entity accountjid = valueMap.get("accountjid") instanceof Entity ? (Entity)valueMap.get("accountjid") : (valueMap.get("accountjid") != null ? EntityImpl.parseUnchecked((String)valueMap.get("accountjid")) : null);
        boolean success = this.checkPassword(notes, accountjid, password = (String)valueMap.get("password"), password2 = (String)valueMap.get("password-verify"));
        if (!success) {
            return this.sendForm();
        }
        if (this.constrainedJID != null && !this.constrainedJID.equals(accountjid)) {
            notes.add(Note.error("password change only allowed for " + this.constrainedJID.getFullQualifiedName()));
            return this.sendForm();
        }
        try {
            this.accountManagement.changePassword(accountjid, password);
        }
        catch (AccountCreationException e) {
            notes.add(Note.error("changing password failed for " + accountjid));
            return this.sendForm();
        }
        this.isExecuting = false;
        return null;
    }
}

