/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0119_xmppping;

import java.util.ArrayList;
import java.util.List;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultIQHandler;
import org.apache.vysper.xmpp.modules.extension.xep0119_xmppping.XmppPinger;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;

public class XmppPingIQHandler
extends DefaultIQHandler {
    private List<XmppPinger> pingers = new ArrayList<XmppPinger>();

    public boolean verify(Stanza stanza) {
        String id;
        boolean extension = super.verify(stanza);
        if (extension) {
            return true;
        }
        String type = stanza.getAttributeValue("type");
        return type != null && type.equals("result") && (id = stanza.getAttributeValue("id")) != null && id.startsWith("xmppping-");
    }

    protected void addPinger(XmppPinger pinger) {
        this.pingers.add(pinger);
    }

    protected void removePinger(XmppPinger pinger) {
        this.pingers.remove(pinger);
    }

    protected boolean verifyNamespace(Stanza stanza) {
        return this.verifyInnerNamespace(stanza, "urn:xmpp:ping");
    }

    protected boolean verifyInnerElement(Stanza stanza) {
        return this.verifyInnerElementWorker(stanza, "ping");
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        StanzaBuilder stanzaBuilder = StanzaBuilder.createIQStanza(stanza.getTo(), stanza.getFrom(), IQStanzaType.RESULT, stanza.getID());
        return (Stanza)stanzaBuilder.build();
    }

    protected Stanza handleResult(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        for (XmppPinger pinger : this.pingers) {
            pinger.pong(stanza.getID());
        }
        return null;
    }
}

