/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.delivery.inbound;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.vysper.storage.StorageProviderRegistry;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityUtils;
import org.apache.vysper.xmpp.authorization.AccountManagement;
import org.apache.vysper.xmpp.delivery.OfflineStanzaReceiver;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.delivery.failure.DeliveredToOfflineReceiverException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.delivery.failure.LocalRecipientOfflineException;
import org.apache.vysper.xmpp.delivery.failure.NoSuchLocalUserException;
import org.apache.vysper.xmpp.delivery.failure.ServiceNotAvailableException;
import org.apache.vysper.xmpp.delivery.inbound.RelayResult;
import org.apache.vysper.xmpp.modules.extension.xep0160_offline_storage.OfflineStorageProvider;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.protocol.StanzaProcessor;
import org.apache.vysper.xmpp.protocol.worker.InboundStanzaProtocolWorker;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.MessageStanza;
import org.apache.vysper.xmpp.stanza.MessageStanzaType;
import org.apache.vysper.xmpp.stanza.PresenceStanza;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;
import org.apache.vysper.xmpp.state.resourcebinding.ResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveringInternalInboundStanzaRelay
implements StanzaRelay {
    final Logger logger = LoggerFactory.getLogger(DeliveringInternalInboundStanzaRelay.class);
    private static final InboundStanzaProtocolWorker INBOUND_STANZA_PROTOCOL_WORKER = new InboundStanzaProtocolWorker();
    private static final Integer PRIO_THRESHOLD = 0;
    protected ResourceRegistry resourceRegistry;
    protected ExecutorService executor;
    protected AccountManagement accountVerification;
    protected OfflineStanzaReceiver offlineStanzaReceiver = null;
    protected Entity serverEntity;
    protected ServerRuntimeContext serverRuntimeContext = null;

    public DeliveringInternalInboundStanzaRelay(Entity serverEntity, ResourceRegistry resourceRegistry, StorageProviderRegistry storageProviderRegistry) {
        this(serverEntity, resourceRegistry, (AccountManagement)storageProviderRegistry.retrieve(AccountManagement.class), (OfflineStanzaReceiver)((Object)storageProviderRegistry.retrieve(OfflineStorageProvider.class)));
    }

    public DeliveringInternalInboundStanzaRelay(Entity serverEntity, ResourceRegistry resourceRegistry, AccountManagement accountVerification, OfflineStanzaReceiver offlineStanzaReceiver) {
        this.serverEntity = serverEntity;
        this.resourceRegistry = resourceRegistry;
        this.accountVerification = accountVerification;
        this.offlineStanzaReceiver = offlineStanzaReceiver;
        int coreThreadCount = 10;
        int maxThreadCount = 20;
        int threadTimeoutSeconds = 120000;
        this.executor = new ThreadPoolExecutor(coreThreadCount, maxThreadCount, threadTimeoutSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void setServerRuntimeContext(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public void relay(Entity receiver, Stanza stanza, DeliveryFailureStrategy deliveryFailureStrategy) throws DeliveryException {
        Future<RelayResult> resultFuture = this.executor.submit(new Relay(receiver, stanza, deliveryFailureStrategy));
    }

    private static class UnmodifyableSessionStateHolder
    extends SessionStateHolder {
        private UnmodifyableSessionStateHolder() {
        }

        public void setState(SessionState newState) {
            throw new RuntimeException("unable to alter state");
        }

        public SessionState getState() {
            return SessionState.AUTHENTICATED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Relay
    implements Callable<RelayResult> {
        private Entity receiver;
        private Stanza stanza;
        private DeliveryFailureStrategy deliveryFailureStrategy;
        protected final UnmodifyableSessionStateHolder sessionStateHolder = new UnmodifyableSessionStateHolder();

        Relay(Entity receiver, Stanza stanza, DeliveryFailureStrategy deliveryFailureStrategy) {
            this.receiver = receiver;
            this.stanza = stanza;
            this.deliveryFailureStrategy = deliveryFailureStrategy;
        }

        public Entity getReceiver() {
            return this.receiver;
        }

        public Stanza getStanza() {
            return this.stanza;
        }

        public DeliveryFailureStrategy getDeliveryFailureStrategy() {
            return this.deliveryFailureStrategy;
        }

        @Override
        public RelayResult call() {
            RelayResult relayResult = this.deliver();
            if (relayResult == null || !relayResult.hasProcessingErrors()) {
                return relayResult;
            }
            return this.runFailureStrategy(relayResult);
        }

        private RelayResult runFailureStrategy(RelayResult relayResult) {
            if (this.deliveryFailureStrategy != null) {
                try {
                    this.deliveryFailureStrategy.process(this.stanza, relayResult.getProcessingErrors());
                }
                catch (DeliveryException e) {
                    return new RelayResult(e);
                }
                catch (RuntimeException e) {
                    return new RelayResult(new DeliveryException(e));
                }
            }
            return relayResult;
        }

        protected RelayResult deliver() {
            try {
                String receiverDomain = this.receiver.getDomain();
                if (receiverDomain != null && !EntityUtils.isAddressingServer(this.receiver, DeliveringInternalInboundStanzaRelay.this.serverEntity)) {
                    if (DeliveringInternalInboundStanzaRelay.this.serverRuntimeContext == null) {
                        return new RelayResult(new ServiceNotAvailableException("cannot retrieve component from server context"));
                    }
                    if (!EntityUtils.isAddressingServerComponent(this.receiver, DeliveringInternalInboundStanzaRelay.this.serverEntity)) {
                        return new RelayResult(new ServiceNotAvailableException("unsupported domain " + receiverDomain));
                    }
                    StanzaProcessor processor = DeliveringInternalInboundStanzaRelay.this.serverRuntimeContext.getComponentStanzaProcessor(this.receiver);
                    if (processor == null) {
                        return new RelayResult(new ServiceNotAvailableException("cannot retrieve component stanza processor for" + receiverDomain));
                    }
                    processor.processStanza(DeliveringInternalInboundStanzaRelay.this.serverRuntimeContext, null, this.stanza, null);
                    return new RelayResult();
                }
                if (this.receiver.isResourceSet()) {
                    return this.deliverToFullJID();
                }
                return this.deliverToBareJID();
            }
            catch (RuntimeException e) {
                return new RelayResult(new DeliveryException(e));
            }
        }

        private RelayResult deliverToBareJID() {
            XMPPCoreStanza xmppStanza = XMPPCoreStanza.getWrapper(this.stanza);
            if (xmppStanza == null) {
                return new RelayResult(new DeliveryException("unable to deliver stanza which is not IQ, presence or message"));
            }
            if (PresenceStanza.isOfType(this.stanza)) {
                return this.relayToAllSessions();
            }
            if (MessageStanza.isOfType(this.stanza)) {
                MessageStanza messageStanza = (MessageStanza)xmppStanza;
                MessageStanzaType messageStanzaType = messageStanza.getMessageType();
                switch (messageStanzaType) {
                    case CHAT: 
                    case NORMAL: {
                        return DeliveringInternalInboundStanzaRelay.this.serverRuntimeContext.getServerFeatures().isDeliveringMessageToHighestPriorityResourcesOnly() ? this.relayToBestSessions(false) : this.relayToAllSessions(0);
                    }
                    case ERROR: {
                        return null;
                    }
                    case GROUPCHAT: {
                        return new RelayResult(new ServiceNotAvailableException());
                    }
                    case HEADLINE: {
                        return this.relayToAllSessions();
                    }
                }
                throw new RuntimeException("unhandled message type " + messageStanzaType.value());
            }
            if (IQStanza.isOfType(this.stanza)) {
                throw new RuntimeException("inbound IQ not yet handled");
            }
            return this.relayNotPossible();
        }

        private RelayResult deliverToFullJID() {
            XMPPCoreStanza xmppStanza = XMPPCoreStanza.getWrapper(this.stanza);
            if (xmppStanza == null) {
                new RelayResult(new DeliveryException("unable to deliver stanza which is not IQ, presence or message"));
            }
            if (PresenceStanza.isOfType(this.stanza)) {
                return this.relayToBestSessions(false);
            }
            if (MessageStanza.isOfType(this.stanza)) {
                MessageStanza messageStanza = (MessageStanza)xmppStanza;
                MessageStanzaType messageStanzaType = messageStanza.getMessageType();
                boolean fallbackToBareJIDAllowed = messageStanzaType == MessageStanzaType.CHAT || messageStanzaType == MessageStanzaType.HEADLINE || messageStanzaType == MessageStanzaType.NORMAL;
                return this.relayToBestSessions(fallbackToBareJIDAllowed);
            }
            if (IQStanza.isOfType(this.stanza)) {
                return this.relayToBestSessions(false);
            }
            return new RelayResult(new ServiceNotAvailableException());
        }

        private RelayResult relayNotPossible() {
            if (!DeliveringInternalInboundStanzaRelay.this.accountVerification.verifyAccountExists(this.receiver)) {
                DeliveringInternalInboundStanzaRelay.this.logger.warn("cannot relay to unexisting receiver {} stanza {}", (Object)this.receiver.getFullQualifiedName(), (Object)this.stanza.toString());
                return new RelayResult(new NoSuchLocalUserException());
            }
            if (DeliveringInternalInboundStanzaRelay.this.offlineStanzaReceiver != null) {
                DeliveringInternalInboundStanzaRelay.this.offlineStanzaReceiver.receive(this.stanza);
                return new RelayResult(new DeliveredToOfflineReceiverException());
            }
            DeliveringInternalInboundStanzaRelay.this.logger.warn("cannot relay to offline receiver {} stanza {}", (Object)this.receiver.getFullQualifiedName(), (Object)this.stanza.toString());
            return new RelayResult(new LocalRecipientOfflineException());
        }

        protected RelayResult relayToBestSessions(boolean fallbackToBareJIDAllowed) {
            List<SessionContext> receivingSessions = DeliveringInternalInboundStanzaRelay.this.resourceRegistry.getHighestPrioSessions(this.receiver, PRIO_THRESHOLD);
            if (receivingSessions.size() == 0 && this.receiver.isResourceSet() && fallbackToBareJIDAllowed) {
                receivingSessions = DeliveringInternalInboundStanzaRelay.this.resourceRegistry.getHighestPrioSessions(this.receiver.getBareJID(), PRIO_THRESHOLD);
            }
            if (receivingSessions.size() == 0) {
                return this.relayNotPossible();
            }
            RelayResult relayResult = new RelayResult();
            for (SessionContext receivingSession : receivingSessions) {
                if (receivingSession.getState() != SessionState.AUTHENTICATED) {
                    relayResult.addProcessingError(new DeliveryException("no relay to non-authenticated sessions"));
                    continue;
                }
                try {
                    StanzaHandler stanzaHandler = receivingSession.getServerRuntimeContext().getHandler(this.stanza);
                    INBOUND_STANZA_PROTOCOL_WORKER.processStanza(receivingSession, this.sessionStateHolder, this.stanza, stanzaHandler);
                }
                catch (Exception e) {
                    relayResult.addProcessingError(new DeliveryException("no relay to non-authenticated sessions"));
                }
            }
            return relayResult;
        }

        protected RelayResult relayToAllSessions() {
            return this.relayToAllSessions(null);
        }

        protected RelayResult relayToAllSessions(Integer prioThreshold) {
            List<SessionContext> receivingSessions;
            List<SessionContext> list = receivingSessions = prioThreshold == null ? DeliveringInternalInboundStanzaRelay.this.resourceRegistry.getSessions(this.receiver) : DeliveringInternalInboundStanzaRelay.this.resourceRegistry.getSessions(this.receiver, prioThreshold);
            if (receivingSessions.size() == 0) {
                return this.relayNotPossible();
            }
            if (receivingSessions.size() > 1) {
                DeliveringInternalInboundStanzaRelay.this.logger.warn("multiplexing: {} sessions will be processing {} ", (Object)receivingSessions.size(), (Object)this.stanza);
            }
            RelayResult relayResult = new RelayResult();
            for (SessionContext sessionContext : receivingSessions) {
                if (sessionContext.getState() != SessionState.AUTHENTICATED) {
                    relayResult.addProcessingError(new DeliveryException("no relay to non-authenticated sessions"));
                    continue;
                }
                try {
                    StanzaHandler stanzaHandler = sessionContext.getServerRuntimeContext().getHandler(this.stanza);
                    INBOUND_STANZA_PROTOCOL_WORKER.processStanza(sessionContext, this.sessionStateHolder, this.stanza, stanzaHandler);
                }
                catch (Exception e) {
                    relayResult.addProcessingError(new DeliveryException(e));
                }
            }
            return relayResult;
        }
    }
}

