/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.delivery;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.stanza.Stanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordingStanzaRelay
implements StanzaRelay {
    private final ArrayList<Triple> entityStanzaPairs = new ArrayList();
    private boolean acceptingMode = true;

    @Override
    public void relay(Entity receiver, Stanza stanza, DeliveryFailureStrategy deliveryFailureStrategy) throws DeliveryException {
        if (!this.acceptingMode) {
            return;
        }
        this.entityStanzaPairs.add(new Triple(receiver, stanza, deliveryFailureStrategy));
    }

    public Iterator<Triple> iterator() {
        return this.entityStanzaPairs.iterator();
    }

    public void reset() {
        this.entityStanzaPairs.clear();
    }

    public void setAcceptingMode(boolean accepting) {
        this.acceptingMode = accepting;
    }

    public static class Triple {
        private Entity entity;
        private Stanza stanza;
        private DeliveryFailureStrategy deliveryFailureStrategy;

        Triple(Entity entity, Stanza stanza, DeliveryFailureStrategy deliveryFailureStrategy) {
            this.entity = entity;
            this.stanza = stanza;
            this.deliveryFailureStrategy = deliveryFailureStrategy;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Stanza getStanza() {
            return this.stanza;
        }

        public DeliveryFailureStrategy getDeliveryFailureStrategy() {
            return this.deliveryFailureStrategy;
        }
    }
}

