/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.mina.codec;

import java.nio.charset.CharsetEncoder;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.vysper.charset.CharsetUtil;
import org.apache.vysper.mina.XmppIoHandlerAdapter;
import org.apache.vysper.mina.codec.StanzaWriteInfo;
import org.apache.vysper.xml.fragment.Renderer;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StanzaWriterProtocolEncoder
implements ProtocolEncoder {
    private final Logger logger = LoggerFactory.getLogger(StanzaWriterProtocolEncoder.class);

    public void encode(IoSession ioSession, Object o, ProtocolEncoderOutput protocolEncoderOutput) throws Exception {
        if (!(o instanceof StanzaWriteInfo)) {
            throw new IllegalArgumentException("StanzaWriterProtocolEncoder only handles StanzaWriteInfo objects");
        }
        StanzaWriteInfo stanzaWriteInfo = (StanzaWriteInfo)o;
        Stanza element = stanzaWriteInfo.getStanza();
        Renderer renderer = new Renderer((XMLElement)element);
        IoBuffer byteBuffer = IoBuffer.allocate((int)16).setAutoExpand(true);
        if (stanzaWriteInfo.isWriteProlog()) {
            byteBuffer.putString((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", this.getSessionEncoder());
        }
        if (stanzaWriteInfo.isWriteOpeningElement()) {
            byteBuffer.putString((CharSequence)renderer.getOpeningElement(), this.getSessionEncoder());
        }
        if (stanzaWriteInfo.isWriteContent()) {
            byteBuffer.putString((CharSequence)renderer.getElementContent(), this.getSessionEncoder());
        }
        if (stanzaWriteInfo.isWriteClosingElement()) {
            byteBuffer.putString((CharSequence)renderer.getClosingElement(), this.getSessionEncoder());
        }
        byteBuffer.flip();
        protocolEncoderOutput.write((Object)byteBuffer);
    }

    public void dispose(IoSession ioSession) throws Exception {
        IoHandler handler = ioSession.getHandler();
        if (handler instanceof XmppIoHandlerAdapter) {
            XmppIoHandlerAdapter xmppIoHandlerAdapter = (XmppIoHandlerAdapter)handler;
            xmppIoHandlerAdapter.sessionClosed(ioSession);
            this.logger.debug("terminated and disposed session id = " + ioSession.getId());
        } else {
            this.logger.warn("unhandled StanzaWriterProtocolEncoder.dispose()");
        }
    }

    public CharsetEncoder getSessionEncoder() {
        return CharsetUtil.UTF8_ENCODER;
    }
}

