/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.mina;

import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteToClosedSessionException;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.vysper.mina.MinaBackedSessionContext;
import org.apache.vysper.xml.fragment.XMLText;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StreamErrorCondition;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class XmppIoHandlerAdapter
implements IoHandler {
    public static final String ATTRIBUTE_VYSPER_SESSION = "vysperSession";
    public static final String ATTRIBUTE_VYSPER_SESSIONSTATEHOLDER = "vysperSessionStateHolder";
    final Logger logger = LoggerFactory.getLogger(XmppIoHandlerAdapter.class);
    private ServerRuntimeContext serverRuntimeContext;

    public void setServerRuntimeContext(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public void messageReceived(IoSession ioSession, Object message) throws Exception {
        if (!(message instanceof Stanza)) {
            String text;
            if (message instanceof XMLText && (text = ((XMLText)message).getText()).length() < 40 && text.trim().length() == 0) {
                return;
            }
            this.messageReceivedNoStanza(ioSession, message);
            return;
        }
        Stanza stanza = (Stanza)((Object)message);
        SessionContext session = this.extractSession(ioSession);
        SessionStateHolder stateHolder = (SessionStateHolder)ioSession.getAttribute((Object)ATTRIBUTE_VYSPER_SESSIONSTATEHOLDER);
        this.serverRuntimeContext.getStanzaProcessor().processStanza(this.serverRuntimeContext, session, stanza, stateHolder);
    }

    private void messageReceivedNoStanza(IoSession ioSession, Object message) {
        if (message == SslFilter.SESSION_SECURED) {
            SessionContext session = this.extractSession(ioSession);
            SessionStateHolder stateHolder = (SessionStateHolder)ioSession.getAttribute((Object)ATTRIBUTE_VYSPER_SESSIONSTATEHOLDER);
            this.serverRuntimeContext.getStanzaProcessor().processTLSEstablished(session, stateHolder);
            return;
        }
        if (message == SslFilter.SESSION_UNSECURED) {
            return;
        }
        throw new IllegalArgumentException("xmpp handler only accepts Stanza-typed messages, but received type " + message.getClass());
    }

    private SessionContext extractSession(IoSession ioSession) {
        return (SessionContext)ioSession.getAttribute((Object)ATTRIBUTE_VYSPER_SESSION);
    }

    public void messageSent(IoSession ioSession, Object o) throws Exception {
    }

    public void sessionCreated(IoSession ioSession) throws Exception {
        SessionStateHolder stateHolder = new SessionStateHolder();
        MinaBackedSessionContext sessionContext = new MinaBackedSessionContext(this.serverRuntimeContext, stateHolder, ioSession);
        ioSession.setAttribute((Object)ATTRIBUTE_VYSPER_SESSION, (Object)sessionContext);
        ioSession.setAttribute((Object)ATTRIBUTE_VYSPER_SESSIONSTATEHOLDER, (Object)stateHolder);
    }

    public void sessionOpened(IoSession ioSession) throws Exception {
        this.logger.info("new session from {} has been opened", (Object)ioSession.getRemoteAddress());
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        SessionContext sessionContext = this.extractSession(ioSession);
        String sessionId = "UNKNOWN";
        if (sessionContext != null) {
            sessionId = sessionContext.getSessionId();
            sessionContext.endSession(SessionContext.SessionTerminationCause.CONNECTION_ABORT);
        }
        this.logger.info("session {} has been closed", (Object)sessionId);
    }

    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) throws Exception {
        this.logger.debug("session {} is idle", (Object)((SessionContext)ioSession.getAttribute((Object)ATTRIBUTE_VYSPER_SESSION)).getSessionId());
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) throws Exception {
        Stanza errorStanza;
        SessionContext sessionContext = this.extractSession(ioSession);
        if (throwable.getCause() != null && throwable.getCause() instanceof SAXParseException) {
            this.logger.info("Client sent not well-formed XML, closing session: {}", throwable);
            errorStanza = ServerErrorResponses.getStreamError(StreamErrorCondition.XML_NOT_WELL_FORMED, sessionContext.getXMLLang(), "Stanza not well-formed", null);
        } else {
            if (throwable instanceof WriteToClosedSessionException) {
                return;
            }
            this.logger.warn("error caught on transportation layer: {}", throwable);
            errorStanza = ServerErrorResponses.getStreamError(StreamErrorCondition.UNDEFINED_CONDITION, sessionContext.getXMLLang(), "Unknown error", null);
        }
        sessionContext.getResponseWriter().write(errorStanza);
        sessionContext.endSession(SessionContext.SessionTerminationCause.STREAM_ERROR);
    }
}

