/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.xep0124;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.vysper.mina.TCPEndpoint;
import org.apache.vysper.storage.StorageProviderRegistry;
import org.apache.vysper.storage.inmemory.MemoryStorageProviderRegistry;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AccountCreationException;
import org.apache.vysper.xmpp.authorization.AccountManagement;
import org.apache.vysper.xmpp.extension.xep0124.BoshEndpoint;
import org.apache.vysper.xmpp.modules.Module;
import org.apache.vysper.xmpp.modules.extension.xep0049_privatedata.PrivateDataModule;
import org.apache.vysper.xmpp.modules.extension.xep0054_vcardtemp.VcardTempModule;
import org.apache.vysper.xmpp.modules.extension.xep0092_software_version.SoftwareVersionModule;
import org.apache.vysper.xmpp.modules.extension.xep0119_xmppping.XmppPingModule;
import org.apache.vysper.xmpp.modules.extension.xep0202_entity_time.EntityTimeModule;
import org.apache.vysper.xmpp.server.Endpoint;
import org.apache.vysper.xmpp.server.XMPPServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMain {
    public static void main(String[] args) throws AccountCreationException, EntityFormatException, FileNotFoundException {
        EntityImpl user3;
        EntityImpl user2;
        EntityImpl user1;
        MemoryStorageProviderRegistry providerRegistry;
        AccountManagement accountManagement;
        String addedModuleProperty = System.getProperty("vysper.add.module");
        List<Module> listOfModules = null;
        if (addedModuleProperty != null) {
            String[] moduleClassNames = addedModuleProperty.split(",");
            listOfModules = ServerMain.createModuleInstances(moduleClassNames);
        }
        if (!(accountManagement = (AccountManagement)(providerRegistry = new MemoryStorageProviderRegistry()).retrieve(AccountManagement.class)).verifyAccountExists((Entity)(user1 = EntityImpl.parse((String)"user1@vysper.org")))) {
            accountManagement.addUser((Entity)user1, "password1");
        }
        if (!accountManagement.verifyAccountExists((Entity)(user2 = EntityImpl.parse((String)"user2@vysper.org")))) {
            accountManagement.addUser((Entity)user2, "password1");
        }
        if (!accountManagement.verifyAccountExists((Entity)(user3 = EntityImpl.parse((String)"user3@vysper.org")))) {
            accountManagement.addUser((Entity)user3, "password1");
        }
        XMPPServer server = new XMPPServer("vysper.org");
        server.addEndpoint((Endpoint)new TCPEndpoint());
        BoshEndpoint boshEndpoint = new BoshEndpoint();
        boshEndpoint.setAccessControlAllowOrigin(Arrays.asList("*"));
        boshEndpoint.setContextPath("/bosh");
        server.addEndpoint((Endpoint)boshEndpoint);
        server.setStorageProviderRegistry((StorageProviderRegistry)providerRegistry);
        server.setTLSCertificateInfo(new File("src/test/resources/bogus_mina_tls.cert"), "boguspw");
        try {
            server.start();
            System.out.println("vysper server is running...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        server.addModule((Module)new SoftwareVersionModule());
        server.addModule((Module)new EntityTimeModule());
        server.addModule((Module)new VcardTempModule());
        server.addModule((Module)new XmppPingModule());
        server.addModule((Module)new PrivateDataModule());
        if (listOfModules != null) {
            for (Module module : listOfModules) {
                server.addModule(module);
            }
        }
    }

    private static List<Module> createModuleInstances(String[] moduleClassNames) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (String moduleClassName : moduleClassNames) {
            Class<?> moduleClass;
            try {
                moduleClass = Class.forName(moduleClassName);
            }
            catch (ClassCastException e) {
                System.err.println("not a Vysper module class: " + moduleClassName);
                continue;
            }
            catch (ClassNotFoundException e) {
                System.err.println("could not load module class " + moduleClassName);
                continue;
            }
            try {
                Module module = (Module)moduleClass.newInstance();
                modules.add(module);
            }
            catch (Exception e) {
                System.err.println("failed to instantiate module class " + moduleClassName);
            }
        }
        return modules;
    }
}

