/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import org.apache.directory.api.i18n.I18n;

public class ExpansibleByteBuffer {
    private static final int DEFAULT_INITIAL_SIZE = 10;
    private final int initialSize;
    private int pos = 0;
    private byte[] buf;

    public ExpansibleByteBuffer() {
        this(10);
    }

    public ExpansibleByteBuffer(int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_17042_INITIAL_SIZE_ABOVE_ZERO, (Object[])new Object[0]));
        }
        this.initialSize = initialSize;
        this.buf = new byte[initialSize];
    }

    public final void clear() {
        this.pos = 0;
    }

    public final int position() {
        return this.pos;
    }

    public final void position(int pos) {
        this.pos = pos;
    }

    public final int capacity() {
        return this.buf.length;
    }

    public final byte get(int i) {
        return this.buf[i];
    }

    public final byte[] buffer() {
        return this.buf;
    }

    public final byte[] copyOfUsedBytes() {
        byte[] copy = new byte[this.pos];
        System.arraycopy(this.buf, 0, copy, 0, this.pos);
        return copy;
    }

    public final void append(byte[] bytes) {
        if (this.pos + bytes.length > this.buf.length) {
            this.growBuffer(bytes.length);
        }
        System.arraycopy(bytes, 0, this.buf, this.pos, bytes.length);
        this.pos += bytes.length;
    }

    public final void append(byte b) {
        if (this.pos >= this.buf.length) {
            this.growBuffer();
        }
        this.buf[this.pos] = b;
        ++this.pos;
    }

    public final void append(int val) {
        if (this.pos >= this.buf.length) {
            this.growBuffer();
        }
        this.buf[this.pos] = (byte)val;
        ++this.pos;
    }

    private void growBuffer(int size) {
        if (size > this.initialSize) {
            byte[] copy = new byte[this.buf.length + size];
            System.arraycopy(this.buf, 0, copy, 0, this.pos);
            this.buf = copy;
        } else {
            byte[] copy = new byte[this.buf.length + this.initialSize];
            System.arraycopy(this.buf, 0, copy, 0, this.pos);
            this.buf = copy;
        }
    }

    private void growBuffer() {
        byte[] copy = new byte[this.buf.length + this.initialSize];
        System.arraycopy(this.buf, 0, copy, 0, this.pos);
        this.buf = copy;
    }
}

