/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.deploy.impl;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ServiceDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterDescriptor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.dispatch.GatewayDispatchFilter;
import org.apache.knox.gateway.filter.XForwardedHeaderFilter;
import org.apache.knox.gateway.filter.rewrite.api.CookieScopeServletFilter;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.service.definition.CustomDispatch;
import org.apache.knox.gateway.service.definition.Policy;
import org.apache.knox.gateway.service.definition.Rewrite;
import org.apache.knox.gateway.service.definition.Route;
import org.apache.knox.gateway.service.definition.ServiceDefinition;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Version;

public class ServiceDefinitionDeploymentContributor
extends ServiceDeploymentContributorBase {
    private static final String DISPATCH_ROLE = "dispatch";
    private static final String DISPATCH_IMPL_PARAM = "dispatch-impl";
    private static final String HTTP_CLIENT_FACTORY_PARAM = "httpClientFactory";
    private static final String SERVICE_ROLE_PARAM = "serviceRole";
    private static final String XFORWARDED_FILTER_NAME = "XForwardedHeaderFilter";
    private static final String XFORWARDED_FILTER_ROLE = "xforwardedheaders";
    private static final String DEFAULT_HA_DISPATCH_CLASS = "org.apache.knox.gateway.ha.dispatch.DefaultHaDispatch";
    private static final String COOKIE_SCOPING_FILTER_NAME = "CookieScopeServletFilter";
    private static final String COOKIE_SCOPING_FILTER_ROLE = "cookiescopef";
    private static final String APPEND_SERVICE_NAME_PARAM = "isAppendServiceName";
    private static final String SERVICE_CONTEXT = "serviceContext";
    private ServiceDefinition serviceDefinition;
    private UrlRewriteRulesDescriptor serviceRules;

    public ServiceDefinitionDeploymentContributor(ServiceDefinition serviceDefinition, UrlRewriteRulesDescriptor serviceRules) {
        this.serviceDefinition = serviceDefinition;
        this.serviceRules = serviceRules;
    }

    public String getRole() {
        return this.serviceDefinition.getRole();
    }

    public String getName() {
        return this.serviceDefinition.getName();
    }

    public Version getVersion() {
        return new Version(this.serviceDefinition.getVersion());
    }

    public void contributeService(DeploymentContext context, Service service) throws Exception {
        this.contributeRewriteRules(context);
        this.contributeResources(context, service);
    }

    private void contributeRewriteRules(DeploymentContext context) {
        if (this.serviceRules != null) {
            UrlRewriteRulesDescriptor clusterRules = (UrlRewriteRulesDescriptor)context.getDescriptor("rewrite");
            clusterRules.addRules(this.serviceRules);
        }
    }

    private void contributeResources(DeploymentContext context, Service service) {
        HashMap<String, String> filterParams = new HashMap<String, String>();
        List bindings = this.serviceDefinition.getRoutes();
        for (Route binding : bindings) {
            List filters = binding.getRewrites();
            if (filters != null && !filters.isEmpty()) {
                filterParams.clear();
                for (Rewrite filter : filters) {
                    filterParams.put(filter.getTo(), filter.getApply());
                }
            }
            try {
                this.contributeResource(context, service, binding, filterParams);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void contributeResource(DeploymentContext context, Service service, Route binding, Map<String, String> filterParams) throws URISyntaxException {
        List policyBindings;
        FilterDescriptor filter;
        ArrayList<FilterParamDescriptor> params = new ArrayList<FilterParamDescriptor>();
        ResourceDescriptor resource = context.getGatewayDescriptor().addResource();
        resource.role(service.getRole());
        resource.pattern(binding.getPath());
        if (context.getGatewayConfig().isXForwardedEnabled()) {
            filter = resource.addFilter().name(XFORWARDED_FILTER_NAME).role(XFORWARDED_FILTER_ROLE).impl(XForwardedHeaderFilter.class);
            if (service.getParams().containsKey(SERVICE_CONTEXT)) {
                filter.param().name(APPEND_SERVICE_NAME_PARAM).value("true");
                filter.param().name(SERVICE_CONTEXT).value((String)service.getParams().get(SERVICE_CONTEXT));
            } else if (context.getGatewayConfig().getXForwardContextAppendServices() != null && !context.getGatewayConfig().getXForwardContextAppendServices().isEmpty() && context.getGatewayConfig().getXForwardContextAppendServices().contains(service.getRole())) {
                filter.param().name(APPEND_SERVICE_NAME_PARAM).value("true");
            }
        }
        if (context.getGatewayConfig().isCookieScopingToPathEnabled()) {
            filter = resource.addFilter().name(COOKIE_SCOPING_FILTER_NAME).role(COOKIE_SCOPING_FILTER_ROLE).impl(CookieScopeServletFilter.class);
            filter.param().name("gateway.path").value(context.getGatewayConfig().getGatewayPath());
            filter.param().name("topologyName").value(context.getTopology().getName());
        }
        if ((policyBindings = binding.getPolicies()) == null) {
            policyBindings = this.serviceDefinition.getPolicies();
        }
        if (policyBindings == null) {
            this.addDefaultPolicies(context, service, filterParams, params, resource);
        } else {
            this.addPolicies(context, service, filterParams, params, resource, policyBindings);
        }
        this.addDispatchFilter(context, service, resource, binding);
    }

    private void addPolicies(DeploymentContext context, Service service, Map<String, String> filterParams, List<FilterParamDescriptor> params, ResourceDescriptor resource, List<Policy> policyBindings) throws URISyntaxException {
        for (Policy policyBinding : policyBindings) {
            String role = policyBinding.getRole();
            if (role == null) {
                throw new IllegalArgumentException("Policy defined has no role for service " + service.getName());
            }
            if ("rewrite".equals(role = role.trim().toLowerCase(Locale.ROOT))) {
                this.addRewriteFilter(context, service, filterParams, params, resource);
                continue;
            }
            if (this.topologyContainsProviderType(context, role)) {
                context.contributeFilter(service, resource, role, policyBinding.getName(), null);
                continue;
            }
            if (!"authentication".equalsIgnoreCase(role) || !this.topologyContainsProviderType(context, "federation")) continue;
            context.contributeFilter(service, resource, role, policyBinding.getName(), null);
        }
    }

    private void addDefaultPolicies(DeploymentContext context, Service service, Map<String, String> filterParams, List<FilterParamDescriptor> params, ResourceDescriptor resource) throws URISyntaxException {
        this.addWebAppSecFilters(context, service, resource);
        this.addAuthenticationFilter(context, service, resource);
        this.addRewriteFilter(context, service, filterParams, params, resource);
        this.addIdentityAssertionFilter(context, service, resource);
        this.addAuthorizationFilter(context, service, resource);
    }

    private void addRewriteFilter(DeploymentContext context, Service service, Map<String, String> filterParams, List<FilterParamDescriptor> params, ResourceDescriptor resource) throws URISyntaxException {
        if (!filterParams.isEmpty()) {
            for (Map.Entry<String, String> filterParam : filterParams.entrySet()) {
                params.add(resource.createFilterParam().name(filterParam.getKey()).value(filterParam.getValue()));
            }
        }
        this.addRewriteFilter(context, service, resource, params);
    }

    private void addDispatchFilter(DeploymentContext context, Service service, ResourceDescriptor resource, Route binding) {
        CustomDispatch customDispatch = binding.getDispatch();
        if (service.getDispatch() != null) {
            customDispatch = service.getDispatch();
        }
        if (customDispatch == null) {
            customDispatch = this.serviceDefinition.getDispatch();
        }
        boolean isHaEnabled = this.isHaEnabled(context);
        if (customDispatch != null) {
            String haContributorName = customDispatch.getHaContributorName();
            String haClassName = customDispatch.getHaClassName();
            String httpClientFactory = customDispatch.getHttpClientFactory();
            boolean useTwoWaySsl = customDispatch.getUseTwoWaySsl();
            Map dispatchParams = customDispatch.getParams();
            if (isHaEnabled) {
                if (haContributorName != null) {
                    this.addDispatchFilter(context, service, resource, DISPATCH_ROLE, haContributorName, dispatchParams);
                } else if (haClassName != null) {
                    this.addDispatchFilterForClass(context, service, resource, haClassName, httpClientFactory, useTwoWaySsl, dispatchParams);
                } else {
                    this.addDefaultHaDispatchFilter(context, service, resource, dispatchParams);
                }
            } else {
                String contributorName = customDispatch.getContributorName();
                if (contributorName != null) {
                    this.addDispatchFilter(context, service, resource, DISPATCH_ROLE, contributorName, dispatchParams);
                } else {
                    String className = customDispatch.getClassName();
                    if (className != null) {
                        this.addDispatchFilterForClass(context, service, resource, className, httpClientFactory, useTwoWaySsl, dispatchParams);
                    } else {
                        this.addDispatchFilter(context, service, resource, DISPATCH_ROLE, "http-client", dispatchParams);
                    }
                }
            }
        } else if (isHaEnabled) {
            this.addDefaultHaDispatchFilter(context, service, resource);
        } else {
            this.addDispatchFilter(context, service, resource, DISPATCH_ROLE, "http-client");
        }
    }

    private void addDefaultHaDispatchFilter(DeploymentContext context, Service service, ResourceDescriptor resource) {
        this.addDefaultHaDispatchFilter(context, service, resource, Collections.emptyMap());
    }

    private void addDefaultHaDispatchFilter(DeploymentContext context, Service service, ResourceDescriptor resource, Map<String, String> dispatchParams) {
        this.addDispatchFilterForClass(context, service, resource, DEFAULT_HA_DISPATCH_CLASS, null, dispatchParams);
    }

    private void addDispatchFilterForClass(DeploymentContext context, Service service, ResourceDescriptor resource, String dispatchClass, String httpClientFactory, boolean useTwoWaySsl, Map<String, String> dispatchParams) {
        FilterDescriptor filter = resource.addFilter().name(this.getName()).role(DISPATCH_ROLE).impl(GatewayDispatchFilter.class);
        filter.param().name(DISPATCH_IMPL_PARAM).value(dispatchClass);
        if (httpClientFactory != null) {
            filter.param().name(HTTP_CLIENT_FACTORY_PARAM).value(httpClientFactory);
        }
        if (dispatchParams != null) {
            for (Map.Entry<String, String> entry : dispatchParams.entrySet()) {
                filter.param().name(entry.getKey()).value(entry.getValue());
            }
        }
        filter.param().name("useTwoWaySsl").value(Boolean.toString(useTwoWaySsl));
        for (Map.Entry<String, String> entry : service.getParams().entrySet()) {
            filter.param().name(entry.getKey()).value(entry.getValue());
        }
        if (context.getGatewayConfig().isHadoopKerberosSecured()) {
            filter.param().name("kerberos").value("true");
        } else {
            filter.param().name("basicAuthPreemptive").value("true");
        }
        filter.param().name(SERVICE_ROLE_PARAM).value(service.getRole());
    }

    private void addDispatchFilterForClass(DeploymentContext context, Service service, ResourceDescriptor resource, String dispatchClass, String httpClientFactory, Map<String, String> dispatchParams) {
        this.addDispatchFilterForClass(context, service, resource, dispatchClass, httpClientFactory, false, dispatchParams);
    }

    private boolean isHaEnabled(DeploymentContext context) {
        Map params;
        Provider provider = this.getProviderByRole(context, "ha");
        return provider != null && provider.isEnabled() && (params = provider.getParams()) != null && params.containsKey(this.getRole());
    }
}

