/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client.finder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.finder.ClientFinder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityClientFinder
implements ClientFinder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSecurityClientFinder.class);
    private String clientNameParameter = "client_name";

    @Override
    public List<Client> find(Clients clients, WebContext context, String clientNames) {
        ArrayList<Client> result = new ArrayList<Client>();
        String securityClientNames = clientNames;
        logger.debug("Provided clientNames: {}", (Object)securityClientNames);
        if (clientNames == null) {
            securityClientNames = clients.getDefaultSecurityClients();
            logger.debug("Default security clients: {}", (Object)securityClientNames);
            if (securityClientNames == null && clients.findAllClients().size() == 1) {
                securityClientNames = clients.getClients().get(0).getName();
                logger.debug("Only client: {}", (Object)securityClientNames);
            }
        }
        if (CommonHelper.isNotBlank(securityClientNames)) {
            List<String> names = Arrays.asList(securityClientNames.split(","));
            String clientNameOnRequest = context.getRequestParameter(this.clientNameParameter);
            logger.debug("clientNameOnRequest: {}", (Object)clientNameOnRequest);
            if (clientNameOnRequest != null) {
                Client client = clients.findClient(clientNameOnRequest);
                String nameFound = client.getName();
                boolean found = false;
                for (String name : names) {
                    if (!CommonHelper.areEqualsIgnoreCaseAndTrim(name, nameFound)) continue;
                    result.add(client);
                    found = true;
                    break;
                }
                if (!found) {
                    throw new TechnicalException("Client not allowed: " + nameFound);
                }
            } else {
                for (String name : names) {
                    Client client = clients.findClient(name);
                    result.add(client);
                }
            }
        }
        logger.debug("result: {}", result.stream().map(c -> c.getName()).collect(Collectors.toList()));
        return result;
    }

    public String getClientNameParameter() {
        return this.clientNameParameter;
    }

    public void setClientNameParameter(String clientNameParameter) {
        this.clientNameParameter = clientNameParameter;
    }
}

