/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.authorizer;

import java.util.List;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;

public abstract class ProfileAuthorizer<U extends CommonProfile>
implements Authorizer<U> {
    public boolean isAllAuthorized(WebContext context, List<U> profiles) {
        for (CommonProfile profile : profiles) {
            if (this.isProfileAuthorized(context, profile)) continue;
            return this.handleError(context);
        }
        return true;
    }

    public boolean isAnyAuthorized(WebContext context, List<U> profiles) {
        for (CommonProfile profile : profiles) {
            if (!this.isProfileAuthorized(context, profile)) continue;
            return true;
        }
        return this.handleError(context);
    }

    protected abstract boolean isProfileAuthorized(WebContext var1, U var2);

    protected boolean handleError(WebContext context) {
        return false;
    }
}

