/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.UsageEnum;

public final class SchemaObjectRenderer {
    public static final SchemaObjectRenderer SUBSCHEMA_SUBENTRY_RENDERER = new SchemaObjectRenderer(Style.SUBSCHEMA_SUBENTRY_WITH_SCHEMA_NAME);
    public static final SchemaObjectRenderer OPEN_LDAP_SCHEMA_RENDERER = new SchemaObjectRenderer(Style.OPENLDAP_SCHEMA_PRETTY_PRINTED);
    private final Style style;

    private SchemaObjectRenderer(Style style) {
        this.style = style;
    }

    public String render(ObjectClass oc) {
        StringBuilder buf = this.renderStartOidNamesDescObsolete(oc, "objectclass");
        this.renderOids(buf, "SUP", oc.getSuperiorOids());
        if (oc.getType() != null) {
            this.prettyPrintIndent(buf);
            buf.append((Object)oc.getType());
            this.prettyPrintNewLine(buf);
        }
        this.renderOids(buf, "MUST", oc.getMustAttributeTypeOids());
        this.renderOids(buf, "MAY", oc.getMayAttributeTypeOids());
        this.renderXSchemaName(oc, buf);
        this.renderClose(buf);
        return buf.toString();
    }

    public String render(AttributeType at) {
        StringBuilder buf = this.renderStartOidNamesDescObsolete(at, "attributetype");
        if (at.getSuperior() != null) {
            this.prettyPrintIndent(buf);
            buf.append("SUP ").append(at.getSuperior().getName());
            this.prettyPrintNewLine(buf);
        } else if (at.getSuperiorOid() != null) {
            this.prettyPrintIndent(buf);
            buf.append("SUP ").append(at.getSuperiorOid());
            this.prettyPrintNewLine(buf);
        }
        if (at.getEquality() != null) {
            this.prettyPrintIndent(buf);
            buf.append("EQUALITY ").append(at.getEquality().getName());
            this.prettyPrintNewLine(buf);
        } else if (at.getEqualityOid() != null) {
            this.prettyPrintIndent(buf);
            buf.append("EQUALITY ").append(at.getEqualityOid());
            this.prettyPrintNewLine(buf);
        }
        if (at.getOrdering() != null) {
            this.prettyPrintIndent(buf);
            buf.append("ORDERING ").append(at.getOrdering().getName());
            this.prettyPrintNewLine(buf);
        } else if (at.getOrderingOid() != null) {
            this.prettyPrintIndent(buf);
            buf.append("ORDERING ").append(at.getOrderingOid());
            this.prettyPrintNewLine(buf);
        }
        if (at.getSubstring() != null) {
            this.prettyPrintIndent(buf);
            buf.append("SUBSTR ").append(at.getSubstring().getName());
            this.prettyPrintNewLine(buf);
        } else if (at.getSubstringOid() != null) {
            this.prettyPrintIndent(buf);
            buf.append("SUBSTR ").append(at.getSubstringOid());
            this.prettyPrintNewLine(buf);
        }
        if (at.getSyntaxOid() != null) {
            this.prettyPrintIndent(buf);
            buf.append("SYNTAX ").append(at.getSyntaxOid());
            if (at.getSyntaxLength() > 0L) {
                buf.append("{").append(at.getSyntaxLength()).append("}");
            }
            this.prettyPrintNewLine(buf);
        }
        if (at.isSingleValued()) {
            this.prettyPrintIndent(buf);
            buf.append("SINGLE-VALUE");
            this.prettyPrintNewLine(buf);
        }
        if (at.isCollective()) {
            this.prettyPrintIndent(buf);
            buf.append("COLLECTIVE");
            this.prettyPrintNewLine(buf);
        }
        if (!at.isUserModifiable()) {
            this.prettyPrintIndent(buf);
            buf.append("NO-USER-MODIFICATION");
            this.prettyPrintNewLine(buf);
        }
        if (at.getUsage() != null) {
            this.prettyPrintIndent(buf);
            buf.append("USAGE ").append(UsageEnum.render(at.getUsage()));
            this.prettyPrintNewLine(buf);
        }
        this.renderXSchemaName(at, buf);
        this.renderClose(buf);
        return buf.toString();
    }

    public String render(MatchingRule mr) {
        StringBuilder buf = this.renderStartOidNamesDescObsolete(mr, "matchingrule");
        this.prettyPrintIndent(buf);
        buf.append("SYNTAX ").append(mr.getSyntaxOid());
        this.prettyPrintNewLine(buf);
        this.renderXSchemaName(mr, buf);
        this.renderClose(buf);
        return buf.toString();
    }

    public String render(LdapSyntax syntax) {
        StringBuilder buf = new StringBuilder();
        if (this.style.startWithSchemaType) {
            buf.append("ldapsyntax ");
        }
        buf.append("( ").append(syntax.getOid());
        this.prettyPrintNewLine(buf);
        this.renderDescription(syntax, buf);
        this.renderXSchemaName(syntax, buf);
        this.prettyPrintIndent(buf);
        if (syntax.isHumanReadable()) {
            buf.append("X-NOT-HUMAN-READABLE 'false'");
        } else {
            buf.append("X-NOT-HUMAN-READABLE 'true'");
        }
        this.prettyPrintNewLine(buf);
        this.renderClose(buf);
        return buf.toString();
    }

    public String render(MatchingRuleUse mru) {
        StringBuilder buf = this.renderStartOidNamesDescObsolete(mru, "matchingruleuse");
        List<String> applies = mru.getApplicableAttributeOids();
        if (applies != null && !applies.isEmpty()) {
            this.prettyPrintIndent(buf);
            buf.append("APPLIES ");
            this.renderOids(buf, applies);
            this.prettyPrintNewLine(buf);
        }
        this.renderXSchemaName(mru, buf);
        this.renderClose(buf);
        return buf.toString();
    }

    public String render(DitContentRule dcr) {
        StringBuilder buf = this.renderStartOidNamesDescObsolete(dcr, "ditcontentrule");
        this.renderOids(buf, "AUX", dcr.getAuxObjectClassOids());
        this.renderOids(buf, "MUST", dcr.getMustAttributeTypeOids());
        this.renderOids(buf, "MAY", dcr.getMayAttributeTypeOids());
        this.renderOids(buf, "NOT", dcr.getNotAttributeTypeOids());
        this.renderXSchemaName(dcr, buf);
        this.renderClose(buf);
        return buf.toString();
    }

    public String render(DitStructureRule dsr) {
        StringBuilder buf = new StringBuilder();
        if (this.style.startWithSchemaType) {
            buf.append("ditstructurerule ");
        }
        buf.append("( ").append(dsr.getRuleId());
        this.renderNames(dsr, buf);
        this.renderDescription(dsr, buf);
        this.renderObsolete(dsr, buf);
        this.prettyPrintIndent(buf);
        buf.append("FORM ").append(dsr.getForm());
        this.prettyPrintNewLine(buf);
        this.renderRuleIds(buf, dsr.getSuperRules());
        this.renderXSchemaName(dsr, buf);
        this.renderClose(buf);
        return buf.toString();
    }

    public String render(NameForm nf) {
        StringBuilder buf = this.renderStartOidNamesDescObsolete(nf, "nameform");
        this.prettyPrintIndent(buf);
        buf.append("OC ").append(nf.getStructuralObjectClassOid());
        this.prettyPrintNewLine(buf);
        this.renderOids(buf, "MUST", nf.getMustAttributeTypeOids());
        this.renderOids(buf, "MAY", nf.getMayAttributeTypeOids());
        this.renderXSchemaName(nf, buf);
        this.renderClose(buf);
        return buf.toString();
    }

    private StringBuilder renderStartOidNamesDescObsolete(SchemaObject so, String schemaObjectType) {
        StringBuilder buf = new StringBuilder();
        if (this.style.startWithSchemaType) {
            buf.append(schemaObjectType).append(' ');
        }
        buf.append("( ").append(so.getOid());
        this.renderNames(so, buf);
        this.renderDescription(so, buf);
        this.renderObsolete(so, buf);
        return buf;
    }

    private void renderNames(SchemaObject so, StringBuilder buf) {
        List<String> names = so.getNames();
        if (names != null && !names.isEmpty()) {
            buf.append(" NAME ");
            this.renderQDescrs(buf, names);
            this.prettyPrintNewLine(buf);
        } else {
            this.prettyPrintNewLine(buf);
        }
    }

    private void renderDescription(SchemaObject so, StringBuilder buf) {
        if (so.getDescription() != null) {
            this.prettyPrintIndent(buf);
            buf.append("DESC ");
            this.renderQDString(buf, so.getDescription());
            this.prettyPrintNewLine(buf);
        }
    }

    private void renderObsolete(SchemaObject so, StringBuilder buf) {
        if (so.isObsolete()) {
            this.prettyPrintIndent(buf);
            buf.append("OBSOLETE");
            this.prettyPrintNewLine(buf);
        }
    }

    private void prettyPrintNewLine(StringBuilder buf) {
        if (this.style.prettyPrint) {
            buf.append('\n');
        } else {
            buf.append(" ");
        }
    }

    private void prettyPrintIndent(StringBuilder buf) {
        if (this.style.prettyPrint) {
            buf.append("\t");
        }
    }

    private StringBuilder renderQDescrs(StringBuilder buf, List<String> qdescrs) {
        if (qdescrs == null || qdescrs.isEmpty()) {
            return buf;
        }
        if (qdescrs.size() == 1) {
            buf.append('\'').append(qdescrs.get(0)).append('\'');
        } else {
            buf.append("( ");
            for (String qdescr : qdescrs) {
                buf.append('\'').append(qdescr).append("' ");
            }
            buf.append(")");
        }
        return buf;
    }

    private void renderOids(StringBuilder buf, String prefix, List<String> oids) {
        if (oids != null && !oids.isEmpty()) {
            this.prettyPrintIndent(buf);
            buf.append(prefix).append(' ');
            this.renderOids(buf, oids);
            this.prettyPrintNewLine(buf);
        }
    }

    private StringBuilder renderOids(StringBuilder buf, List<String> oids) {
        if (oids.size() == 1) {
            buf.append(oids.get(0));
        } else {
            buf.append("( ");
            boolean isFirst = true;
            for (String oid : oids) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(" $ ");
                }
                buf.append(oid);
            }
            buf.append(" )");
        }
        return buf;
    }

    private StringBuilder renderQDString(StringBuilder buf, String qdString) {
        buf.append('\'');
        block4: for (char c : qdString.toCharArray()) {
            switch (c) {
                case '\'': {
                    buf.append("\\27");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\5C");
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        buf.append('\'');
        return buf;
    }

    private StringBuilder renderRuleIds(StringBuilder buf, List<Integer> ruleIds) {
        if (ruleIds != null && !ruleIds.isEmpty()) {
            this.prettyPrintIndent(buf);
            buf.append("SUP ");
            if (ruleIds.size() == 1) {
                buf.append(ruleIds.get(0));
            } else {
                buf.append("( ");
                boolean isFirst = true;
                for (Integer ruleId : ruleIds) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buf.append(" ");
                    }
                    buf.append(ruleId);
                }
                buf.append(" )");
            }
            this.prettyPrintNewLine(buf);
        }
        return buf;
    }

    private void renderXSchemaName(SchemaObject oc, StringBuilder buf) {
        if (this.style.printSchemaName) {
            this.prettyPrintIndent(buf);
            buf.append("X-SCHEMA '");
            buf.append(oc.getSchemaName());
            buf.append("'");
            this.prettyPrintNewLine(buf);
        }
    }

    private void renderClose(StringBuilder buf) {
        if (this.style.prettyPrint && buf.charAt(buf.length() - 1) == '\n') {
            buf.deleteCharAt(buf.length() - 1);
            buf.append(" ");
        }
        buf.append(")");
    }

    private static enum Style {
        SUBSCHEMA_SUBENTRY_WITH_SCHEMA_NAME(false, false, true),
        OPENLDAP_SCHEMA_PRETTY_PRINTED(true, true, false);

        final boolean startWithSchemaType;
        final boolean prettyPrint;
        final boolean printSchemaName;

        private Style(boolean startWithSchemaType, boolean prettyPrint, boolean printSchemaName) {
            this.startWithSchemaType = startWithSchemaType;
            this.prettyPrint = prettyPrint;
            this.printSchemaName = printSchemaName;
        }
    }
}

