/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.util;

import java.io.File;
import java.nio.file.Paths;

public class ClientTrustStoreHelper {
    private static final String DEFAULT_GATEWAY_CLIENT_TRUSTSTORE_DIR = System.getProperty("user.home");
    private static final String DEFAULT_GATEWAY_CLIENT_TRUSTSTORE_FILENAME = "gateway-client-trust.jks";
    private static final String DEFAULT_GATEWAY_CLIENT_TRUSTSTORE_PASSWORD = "changeit";
    private static final String ENV_GATEWAY_CLIENT_TRUSTSTORE_DIR = "GATEWAY_CLIENT_TRUSTSTORE_DIR";
    private static final String ENV_GATEWAY_CLIENT_TRUSTSTORE_FILENAME = "GATEWAY_CLIENT_TRUSTSTORE_FILENAME";
    private static final String ENV_GATEWAY_CLIENT_TRUSTSTORE_PASSWORD = "GATEWAY_CLIENT_TRUSTSTORE_PASS";

    public static File getClientTrustStoreFile() {
        String truststoreDir = ClientTrustStoreHelper.fetchTrustStoreAttribute(ENV_GATEWAY_CLIENT_TRUSTSTORE_DIR, DEFAULT_GATEWAY_CLIENT_TRUSTSTORE_DIR);
        String truststoreFileName = ClientTrustStoreHelper.fetchTrustStoreAttribute(ENV_GATEWAY_CLIENT_TRUSTSTORE_FILENAME, DEFAULT_GATEWAY_CLIENT_TRUSTSTORE_FILENAME);
        return Paths.get(truststoreDir, truststoreFileName).toFile();
    }

    public static String getClientTrustStoreFilePassword() {
        return ClientTrustStoreHelper.fetchTrustStoreAttribute(ENV_GATEWAY_CLIENT_TRUSTSTORE_PASSWORD, DEFAULT_GATEWAY_CLIENT_TRUSTSTORE_PASSWORD);
    }

    private static String fetchTrustStoreAttribute(String environmentVariableName, String defaultValue) {
        String trustStoreAttribute = System.getenv(environmentVariableName);
        return trustStoreAttribute == null ? defaultValue : trustStoreAttribute;
    }
}

