/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.ResultResponseRequest;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyRequestHandler
extends LdapRequestHandler<ModifyRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyRequestHandler.class);

    @Override
    public void handle(LdapSession session, ModifyRequest modifyRequest) {
        LOG.debug("Handling request : {}", (Object)modifyRequest);
        ModifyResponse modifyResponse = (ModifyResponse)modifyRequest.getResultResponse();
        LdapResult result = modifyResponse.getLdapResult();
        try {
            CoreSession coreSession = session.getCoreSession();
            coreSession.modify(modifyRequest);
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write((Object)modifyResponse);
        }
        catch (Exception e) {
            this.handleException(session, (ResultResponseRequest)modifyRequest, (ResultResponse)modifyResponse, e);
        }
    }
}

