/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.j2e.util;

import java.security.Principal;
import java.util.Collection;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileHelper;

public class Pac4JHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private Collection<CommonProfile> profiles;

    public Pac4JHttpServletRequestWrapper(HttpServletRequest request, Collection<CommonProfile> profiles) {
        super(request);
        this.profiles = profiles;
    }

    public String getRemoteUser() {
        return this.getPrincipal().map(p -> p.getName()).orElse(null);
    }

    private Optional<CommonProfile> getProfile() {
        return ProfileHelper.flatIntoOneProfile(this.profiles);
    }

    private Optional<Principal> getPrincipal() {
        return this.getProfile().map(CommonProfile::asPrincipal);
    }

    public Principal getUserPrincipal() {
        return this.getPrincipal().orElse(null);
    }

    public boolean isUserInRole(String role) {
        return this.profiles.stream().anyMatch(p -> p.getRoles().contains(role));
    }
}

